REM Character LCD HD44780 Control Class Rev 2
REM CHRLCD.BAS

REM 4-bit mode fixed
REM DB0-DB3:Open
REM RW:GND
REM Data and Control pins are remappable

REM Usage:
REM A=NEW(DB4,DB5,DB6,DB7,RS,EN)
REM  Init HD44780 and Assign pins port
REM  All parameters are output port numbers

REM Public Metionds List
REM CLR()
REM  Clear LCD
REM CUR(X,Y [,Type] )
REM  Set cursor position and cursor type
REM  Type is optinal 0:no 1:block 2:underline
REM PUTCHR(Chr)
REM  Put one character
REM PUTSTR(String$)
REM  Put string
REM SETCG(Chr,D1,D2)
REM  Set CGRAM(PCG)
REM  Chr:character number(0-7)
REM  D1,D2 :font data(64bit/5x8 dot)
REM  D1:Top half 4-lines, D2:2nd half
REM  Top byte:upper - Lowest byte:bottom


REM ------ CHRLCD Class sample code ------

USECLASS CHRLCD

SYSTEM 200,0
L=NEW(CHRLCD,0,1,2,3,4,5)

L.SETCG(0,$10181C1E,$1F1E1C18)
L.SETCG(1,$0103070F,$1F0F0703)
L.CUR(0,0)
L.PUTCHR($00):L.PUTCHR($01)
FOR I=$30 TO $3D:L.PUTCHR(I):NEXT
L.CUR(0,1):L.PUTSTR("ABCDEFGHIJKLMNOP")

SYSTEM 200,1

END


REM ------ Class code starts here ------

OPTION CLASSCODE

FIELD PRIVATE DB4,DB5,DB6,DB7,RS,EN

METHOD CLR
 GOSUB LCDCOM,$01
 VAR I
 FOR I=1 TO 20000:NEXT
RETURN

METHOD CUR
 GOSUB LCDCOM,$80+ARGS(2)*$40+ARGS(1)
 IF ARGS(0)>2 THEN GOSUB LCDCOM,$0C+ARGS(3)
RETURN

METHOD PUTCHR
 GOSUB LCDDAT,ARGS(1)
RETURN

METHOD PUTSTR
 VAR P
 P=ARGS(1)
 WHILE PEEK(P)
  GOSUB LCDDAT,PEEK(P)
  P=P+1
 WEND
RETURN

METHOD SETCG
 VAR D
 GOSUB LCDCOM,$40+ARGS(1)*8
 D=ARGS(2)
 GOSUB LCDDAT,D>>24
 GOSUB LCDDAT,D>>16
 GOSUB LCDDAT,D>>8
 GOSUB LCDDAT,D
 D=ARGS(3)
 GOSUB LCDDAT,D>>24
 GOSUB LCDDAT,D>>16
 GOSUB LCDDAT,D>>8
 GOSUB LCDDAT,D
RETURN

METHOD INIT
 DB4=ARGS(1)
 DB5=ARGS(2)
 DB6=ARGS(3)
 DB7=ARGS(4)
 RS=ARGS(5)
 EN=ARGS(6)
 WAIT 1
 GOSUB LCDOUT,$03,0
 WAIT 1
 GOSUB LCDOUT,$03,0
 WAIT 1
 GOSUB LCDOUT,$03,0
 WAIT 1
 GOSUB LCDOUT,$02,0
 WAIT 1
 GOSUB LCDCOM,$28
 GOSUB LCDCOM,$0C
 GOSUB LCDCOM,$01
 WAIT 1
 GOSUB LCDCOM,$06
 GOSUB LCDCOM,$02
 WAIT 1
RETURN

LABEL LCDCOM
 REM Command Output
 GOSUB LCDOUT,ARGS(1)>>4,0
 GOSUB LCDOUT,ARGS(1),0
 VAR I
 FOR I=1 TO 200:NEXT
RETURN

LABEL LCDDAT
 REM Data Output
 GOSUB LCDOUT,ARGS(1)>>4,1
 GOSUB LCDOUT,ARGS(1),1
 VAR I
 FOR I=1 TO 200:NEXT
RETURN

LABEL LCDOUT
 REM LCDOUT,DATA,RS
 REM DATA: 4bit data
 REM RS 0:Command 1:Data
 VAR D
 D=ARGS(1)
 OUT DB4,D AND 1
 OUT DB5,(D>>1) AND 1
 OUT DB6,(D>>2) AND 1
 OUT DB7,(D>>3) AND 1
 OUT RS,ARGS(2)
 OUT EN,1
 FOR D=1 TO 10:NEXT
 OUT EN,0
RETURN
