REM QVGA LCD Controller ILI9325 Class
REM IL9325.BAS

REM Pin Assign
REM  LCD's D0-D7 --> Port B0-B7 (Fixed)
REM  Control Pins: Remappable

REM Usage:
REM A=NEW(IL9325,HV,RD,WR,RS,CS,RST)
REM  Init LCD and Assign Control pins port
REM  HV 0:Horizontal other:Vertical
REM  RD,CS,RST Port Number (8 to 18)
REM  WR,RS Port Number (8 to 15)

REM Color Format is 24bit RGB ($RRGGBB)
REM  but converted to 16bit color inside
REM  (RGB565 format)

REM Public Methods List
REM CLR()
REM  Clear LCD
REM DOT(X,Y,Color)
REM  Put dot
REM LIN(X1,Y1,X2,Y2,Color)
REM  Draw line
REM BOX(X1,Y1,X2,Y2,Color)
REM  Draw rectangular
REM BOXF(X1,Y1,X2,Y2,Color)
REM  Draw filled rectangular
REM CIR(X,Y,r,Color)
REM  Draw circle
REM CIRF(X,Y,r,Color)
REM  Draw filled circle
REM PRT(X,Y,Color,Background color,String)
REM  Draw string with System font
REM  Negative Background means transparent

OPTION NOLINENUM
FIELD PRIVATE HV,CS,RS,WR,RD,RST,DX,DY,WRBIT,RSBIT
USEVAR LATB
USEVAR LATBCL
USEVAR LATBST

METHOD DOT
 GOSUB DOT565,ARGS(1),ARGS(2),GOSUB(CVT565,ARGS(3))
RETURN

METHOD LIN
 VAR X,Y,U,V,P,Q,I,E,C
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(5))
 P=ARGS(3)-X:U=1
 IF P<0 THEN P=-P:U=-1
 Q=ARGS(4)-Y:V=1
 IF Q<0 THEN Q=-Q:V=-1
 IF P>=Q THEN
  E=-P
  FOR I=0 TO P
   GOSUB DOT565,X,Y,C
   X=X+U:E=E+Q*2
   IF E>=0 THEN Y=Y+V:E=E-P*2
  NEXT
 ELSE
  E=-Q
  FOR I=0 TO Q
   GOSUB DOT565,X,Y,C
   Y=Y+V:E=E+P*2
   IF E>=0 THEN X=X+U:E=E-Q*2
  NEXT
 ENDIF
RETURN

METHOD BOX
 VAR C,X,Y,U,V
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 C=ARGS(5)
 GOSUB LIN,X,Y,X,V,C
 GOSUB LIN,U,Y,U,V,C
 GOSUB LIN,X,Y,U,Y,C
 GOSUB LIN,X,V,U,V,C
RETURN

METHOD BOXF
 VAR X,Y,U,V,T,C
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 IF X>U THEN T=U:U=X:X=T
 IF Y>V THEN T=V:V=Y:Y=T
 IF U<0 OR V<0 OR X>=DX OR Y>=DY THEN RETURN
 IF X<0 THEN X=0
 IF Y<0 THEN Y=0
 IF U>=DX THEN U=DX-1
 IF V>=DY THEN V=DY-1
 T=U-X+1
 C=GOSUB(CVT565,ARGS(5))
 WHILE Y<=V
  GOSUB HLINE,X,Y,T,C
  Y=Y+1
 WEND
RETURN

METHOD CIR
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB DOT565,U-X,V-Y,C
  GOSUB DOT565,U-X,V+Y,C
  GOSUB DOT565,U+X,V-Y,C
  GOSUB DOT565,U+X,V+Y,C
  GOSUB DOT565,U-Y,V-X,C
  GOSUB DOT565,U-Y,V+X,C
  GOSUB DOT565,U+Y,V-X,C
  GOSUB DOT565,U+Y,V+X,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CIRF
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB HLINE,U-X,V-Y,X*2+1,C
  GOSUB HLINE,U-X,V+Y,X*2+1,C
  GOSUB HLINE,U-Y,V-X,Y*2+1,C
  GOSUB HLINE,U-Y,V+X,Y*2+1,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CLR
 VAR Y
 FOR Y=0 TO DY-1
  GOSUB HLINE,0,Y,DX,0
 NEXT
RETURN

METHOD PRT
 REM PRT,X,Y,C,BC,S$
 VAR X,Y,C,B,S,A,I,J,P,D
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(3))
 B=ARGS(4):IF B>=0 THEN B=GOSUB(CVT565,B)
 S=ARGS(5)
 DO
  A=PEEK(S):IF A=0 THEN BREAK
  P=SYSTEM(103)+A*8:REM System Font Address
  FOR I=0 TO 7
   D=PEEK(P)
   FOR J=0 TO 7
    IF D AND $80 THEN
     GOSUB DOT565,X,Y,C
    ELSEIF B>=0 THEN
     GOSUB DOT565,X,Y,B
    ENDIF
    X=X+1:D=D<<1
   NEXT
   P=P+1:X=X-8:Y=Y+1
  NEXT
  X=X+8:Y=Y-8:S=S+1
 LOOP
RETURN

METHOD INIT
 HV=ARGS(1):RD=ARGS(2):WR=ARGS(3)
 RS=ARGS(4):CS=ARGS(5):RST=ARGS(6)
 LATB=$BF886130
 LATBCL=$BF886134
 LATBST=$BF886138
 WRBIT=1<<WR
 RSBIT=1<<RS

 OUT RS,1
 OUT RD,1
 OUT WR,1
 OUT8L 0
 OUT RST,1
 WAIT 2
 OUT RST,0
 WAIT 2
 OUT RST,1
 WAIT 10
 OUT CS,0

 IF HV THEN
  DX=240:DY=320
  GOSUB LCDREG,$01,$0100
  GOSUB LCDREG,$03,$1010
 ELSE
  DX=320:DY=240
  GOSUB LCDREG,$01,$0000
  GOSUB LCDREG,$03,$1038
 ENDIF
 GOSUB LCDREG,$02, $0700
 GOSUB LCDREG,$04, $0000
 GOSUB LCDREG,$08, $0202
 GOSUB LCDREG,$09, $0000
 GOSUB LCDREG,$10, $0000
 GOSUB LCDREG,$11, $0007
 GOSUB LCDREG,$12, $0000
 GOSUB LCDREG,$13, $0000
 WAIT 10
 GOSUB LCDREG,$10, $16B0
 GOSUB LCDREG,$11, $0227
 WAIT 3
 GOSUB LCDREG,$12, $001c
 WAIT 3
 GOSUB LCDREG,$13, $0A00
 GOSUB LCDREG,$29, $000F
 GOSUB LCDREG,$2b, $000D
 WAIT 3
 GOSUB LCDREG,$20, $0000
 GOSUB LCDREG,$21, $0000
 GOSUB LCDREG,$50, $0000
 GOSUB LCDREG,$51, $00EF
 GOSUB LCDREG,$52, $0000
 GOSUB LCDREG,$60, $A700
 GOSUB LCDREG,$61, $0003
 GOSUB LCDREG,$6a, $0000
 GOSUB LCDREG,$90, $0010
 GOSUB LCDREG,$92, $0000
 GOSUB LCDREG,$93, $0000
 GOSUB LCDREG,$30, $0007
 GOSUB LCDREG,$31, $0403
 GOSUB LCDREG,$32, $0404
 GOSUB LCDREG,$35, $0002
 GOSUB LCDREG,$36, $0707
 GOSUB LCDREG,$37, $0606
 GOSUB LCDREG,$38, $0106
 GOSUB LCDREG,$39, $0007
 GOSUB LCDREG,$3c, $0700
 GOSUB LCDREG,$3d, $0707
 GOSUB LCDREG,$07, $0173
 WAIT 3
RETURN

LABEL CVT565
 REM Convert 24bit Color to 16bit Color(565)
 VAR C
 C=ARGS(1)
 RETURN ((C AND $F80000)>>8)+((C AND $FC00)>>5)+((C AND $F8)>>3)

LABEL DOT565
 VAR X,Y
 X=ARGS(1):Y=ARGS(2)
 IF X>=0 AND X<DX AND Y>=0 AND Y<DY THEN
  IF HV THEN
   GOSUB LCDREG,$20,X:GOSUB LCDREG,$21,Y
  ELSE
   GOSUB LCDREG,$20,Y:GOSUB LCDREG,$21,X
  ENDIF
  GOSUB LCDREG,$22,ARGS(3)
 ENDIF
RETURN

LABEL HLINE
 REM Draw Horizontal Line
 REM StartX,StartY,Length,Color(565)
 VAR X,Y,T,H,L,I
 X=ARGS(1):Y=ARGS(2):T=ARGS(3)
 IF Y<0 OR Y>=DY THEN RETURN
 IF X<0 THEN T=T+X:X=0
 IF T<=0 THEN RETURN
 IF X+T>DX THEN T=DX-X
 L=ARGS(4):H=L>>8
 IF HV THEN
  GOSUB LCDREG,$20,X
  GOSUB LCDREG,$21,Y
 ELSE
  GOSUB LCDREG,$20,Y
  GOSUB LCDREG,$21,X
 ENDIF
 GOSUB LCDCOM,$22
 POKE16 LATBST,RSBIT
 FOR I=1 TO T
  POKE LATB,H: POKE16 LATBCL,WRBIT:POKE16 LATBST,WRBIT
  POKE LATB,L: POKE16 LATBCL,WRBIT:POKE16 LATBST,WRBIT
 NEXT
RETURN

LABEL LCDREG
 GOSUB LCDCOM,ARGS(1)
 GOSUB LCDDAT,ARGS(2)
RETURN

LABEL LCDCOM
 POKE16 LATBCL,RSBIT
 POKE LATB,0
 POKE16 LATBCL,WRBIT
 POKE16 LATBST,WRBIT
 POKE LATB,ARGS(1)
 POKE16 LATBCL,WRBIT
 POKE16 LATBST,WRBIT
RETURN

LABEL LCDDAT
 POKE16 LATBST,RSBIT
 POKE LATB,ARGS(1)>>8
 POKE16 LATBCL,WRBIT
 POKE16 LATBST,WRBIT
 POKE LATB,ARGS(1)
 POKE16 LATBCL,WRBIT
 POKE16 LATBST,WRBIT
RETURN
