REM 240x400 LCD S95461C Class (HX8352-B01)
REM S95461.BAS

REM Pin Assign
REM  LCD's D0-D15 --> Port B0-B15
REM  RST -> D6
REM  CS --> D7
REM  WR --> D8
REM  RS --> D9
REM  RD --> Vdd (Can't read)

REM Usage:
REM A=NEW(S95461,HV)
REM  Init LCD and Assign Control pins port
REM  HV 0:Horizontal other:Vertical

REM Color Format is 24bit RGB ($RRGGBB)
REM  but converted to 16bit color inside
REM  (RGB565 format)

REM Public Methods List
REM CLR()
REM  Clear LCD
REM DOT(X,Y,Color)
REM  Put dot
REM LIN(X1,Y1,X2,Y2,Color)
REM  Draw line
REM BOX(X1,Y1,X2,Y2,Color)
REM  Draw rectangular
REM BOXF(X1,Y1,X2,Y2,Color)
REM  Draw filled rectangular
REM CIR(X,Y,r,Color)
REM  Draw circle
REM CIRF(X,Y,r,Color)
REM  Draw filled circle
REM PRT(X,Y,Color,Background color,String)
REM  Draw string with System font
REM  Negative Background means transparent
REM SETCUR(X,Y)
REM  Set cursor position
REM DOT2(Color)
REM  Put dot cursor position and move cursor


REM   ------ S95461 Class sample code ------

USECLASS S95461
USEVAR LCD,XX,YY

SYSTEM 200,0
XX=240:YY=400
LCD=NEW(S95461,1)
LCD.CLR()

LCD.PRT(80, 90,$FFFFFF,-1,"MachiKania")
LCD.PRT(80,100,$FFFF00,-1,"type M")
LCD.PRT(80,110,$00FFFF,-1,"240x400 LCD")
LCD.PRT(80,120,$00FF00,-1,"BASIC")
LCD.PRT(80,130,$FF00FF,-1,"Library")

FOR I=0 TO 240 STEP 10
 LCD.LIN(I,0,239,I,$00FF00)
 LCD.LIN(239,I,239-I,239,$FF0000)
 LCD.LIN(239-I,239,0,239-I,$0000FF)
 LCD.LIN(0,239-I,I,0,$FFFFFF)
NEXT
WAIT 60
LCD.CLR()

FOR I=1 TO 200
 LCD.LIN(RND()%XX,RND()%YY,RND()%XX,RND()%YY,GOSUB(RNDCOL))
NEXT
WAIT 60

FOR I=1 TO 200
 LCD.CIR(RND()%XX,RND()%YY,RND()%150,GOSUB(RNDCOL))
NEXT
WAIT 60

FOR I=1 TO 200
 LCD.BOXF(RND()%XX,RND()%YY,RND()%XX,RND()%YY,GOSUB(RNDCOL))
NEXT

WAIT 60

FOR I=1 TO 200
 LCD.CIRF(RND()%XX,RND()%YY,RND()%100,GOSUB(RNDCOL))
NEXT

END

LABEL RNDCOL:REM Return 24bit Random Color
RETURN (RND()<<9)+(RND() AND $1FF)


REM   ------ Class code starts here ------

OPTION CLASSCODE

OPTION NOLINENUM
FIELD PRIVATE HV,DX,DY,WRBIT,RSBIT,CSBIT,RSTBIT
USEVAR LATB
USEVAR LATDCL
USEVAR LATDST

METHOD DOT
 GOSUB DOT565,ARGS(1),ARGS(2),GOSUB(CVT565,ARGS(3))
RETURN

METHOD DOT2
  POKE16 LATB,GOSUB(CVT565,ARGS(1))
  POKE16 LATDCL,WRBIT:POKE16 LATDST,WRBIT
RETURN

METHOD LIN
 VAR X,Y,U,V,P,Q,I,E,C
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(5))
 P=ARGS(3)-X:U=1
 IF P<0 THEN P=-P:U=-1
 Q=ARGS(4)-Y:V=1
 IF Q<0 THEN Q=-Q:V=-1
 IF P>=Q THEN
  E=-P
  FOR I=0 TO P
   GOSUB DOT565,X,Y,C
   X=X+U:E=E+Q*2
   IF E>=0 THEN Y=Y+V:E=E-P*2
  NEXT
 ELSE
  E=-Q
  FOR I=0 TO Q
   GOSUB DOT565,X,Y,C
   Y=Y+V:E=E+P*2
   IF E>=0 THEN X=X+U:E=E-Q*2
  NEXT
 ENDIF
RETURN

METHOD BOX
 VAR C,X,Y,U,V
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 C=ARGS(5)
 GOSUB LIN,X,Y,X,V,C
 GOSUB LIN,U,Y,U,V,C
 GOSUB LIN,X,Y,U,Y,C
 GOSUB LIN,X,V,U,V,C
RETURN

METHOD BOXF
 VAR X,Y,U,V,T,C
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 IF X>U THEN T=U:U=X:X=T
 IF Y>V THEN T=V:V=Y:Y=T
 IF U<0 OR V<0 OR X>=DX OR Y>=DY THEN RETURN
 IF X<0 THEN X=0
 IF Y<0 THEN Y=0
 IF U>=DX THEN U=DX-1
 IF V>=DY THEN V=DY-1
 T=U-X+1
 C=GOSUB(CVT565,ARGS(5))
 WHILE Y<=V
  GOSUB HLINE,X,Y,T,C
  Y=Y+1
 WEND
RETURN

METHOD CIR
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB DOT565,U-X,V-Y,C
  GOSUB DOT565,U-X,V+Y,C
  GOSUB DOT565,U+X,V-Y,C
  GOSUB DOT565,U+X,V+Y,C
  GOSUB DOT565,U-Y,V-X,C
  GOSUB DOT565,U-Y,V+X,C
  GOSUB DOT565,U+Y,V-X,C
  GOSUB DOT565,U+Y,V+X,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CIRF
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB HLINE,U-X,V-Y,X*2+1,C
  GOSUB HLINE,U-X,V+Y,X*2+1,C
  GOSUB HLINE,U-Y,V-X,Y*2+1,C
  GOSUB HLINE,U-Y,V+X,Y*2+1,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CLR
 VAR Y
 FOR Y=0 TO DY-1
  GOSUB HLINE,0,Y,DX,0
 NEXT
RETURN

METHOD PRT
 REM PRT,X,Y,C,BC,S$
 VAR X,Y,C,B,S,A,I,J,P,D
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(3))
 B=ARGS(4):IF B>=0 THEN B=GOSUB(CVT565,B)
 S=ARGS(5)
 DO
  A=PEEK(S):IF A=0 THEN BREAK
  P=SYSTEM(103)+A*8:REM System Font Address
  FOR I=0 TO 7
   D=PEEK(P)
   FOR J=0 TO 7
    IF D AND $80 THEN
     GOSUB DOT565,X,Y,C
    ELSEIF B>=0 THEN
     GOSUB DOT565,X,Y,B
    ENDIF
    X=X+1:D=D<<1
   NEXT
   P=P+1:X=X-8:Y=Y+1
  NEXT
  X=X+8:Y=Y-8:S=S+1
 LOOP
RETURN

METHOD SETCUR
 VAR X,Y
 X=ARGS(1):Y=ARGS(2)
 IF X>=0 AND X<DX AND Y>=0 AND Y<DY THEN
  GOSUB LCDADR,X,Y,DX-X-1,1
  POKE16 LATDST,RSBIT
 ENDIF
RETURN

METHOD INIT
 OUT16 0:REM Set PORTB as Output
 POKE16 $BF886310,$3F:REM Set D6-D15 as Output
 HV=ARGS(1)
 LATB=$BF886130
 LATDCL=$BF886334
 LATDST=$BF886338
 WRBIT=$100
 RSBIT=$200
 CSBIT=$80
 RSTBIT=$40

 POKE16 LATDST,WRBIT
 POKE16 LATDST,RSBIT
 POKE16 LATDST,CSBIT
 POKE16 LATDST,RSTBIT

 WAIT 2
 POKE16 LATDCL,RSTBIT
 WAIT 2
 POKE16 LATDST,RSTBIT
 WAIT 10
 POKE16 LATDCL,CSBIT

 GOSUB LCDREG,$E2,$15
 GOSUB LCDREG,$E5,$18
 GOSUB LCDREG,$E7,$18
 GOSUB LCDREG,$E8,$40
 GOSUB LCDREG,$EC,$09
 GOSUB LCDREG,$ED,$06
 GOSUB LCDREG,$EE,$20
 GOSUB LCDREG,$EF,$50
 GOSUB LCDREG,$29,$01
 GOSUB LCDREG,$2B,$03
 GOSUB LCDREG,$2E,$85

 GOSUB LCDREG,$23,$76
 GOSUB LCDREG,$24,$57
 GOSUB LCDREG,$25,$71
 GOSUB LCDREG,$1B,$1E
 GOSUB LCDREG,$01,$00
 GOSUB LCDREG,$1C,$04

 GOSUB LCDREG,$19,$01
 WAIT 1
 GOSUB LCDREG,$1F,$8C
 GOSUB LCDREG,$1F,$84
 WAIT 1
 GOSUB LCDREG,$1F,$94
 WAIT 1
 GOSUB LCDREG,$1F,$D4
 WAIT 1
 GOSUB LCDREG,$40,$08
 GOSUB LCDREG,$41,$31
 GOSUB LCDREG,$42,$2F
 GOSUB LCDREG,$43,$3E
 GOSUB LCDREG,$44,$3D
 GOSUB LCDREG,$45,$3F
 GOSUB LCDREG,$46,$2F
 GOSUB LCDREG,$47,$79
 GOSUB LCDREG,$48,$08
 GOSUB LCDREG,$49,$06
 GOSUB LCDREG,$4A,$08
 GOSUB LCDREG,$4B,$0E
 GOSUB LCDREG,$4C,$17
 GOSUB LCDREG,$50,$00
 GOSUB LCDREG,$51,$02
 GOSUB LCDREG,$52,$01
 GOSUB LCDREG,$53,$10
 GOSUB LCDREG,$54,$0E
 GOSUB LCDREG,$55,$37
 GOSUB LCDREG,$56,$06
 GOSUB LCDREG,$57,$50
 GOSUB LCDREG,$58,$08
 GOSUB LCDREG,$59,$11
 GOSUB LCDREG,$5A,$17
 GOSUB LCDREG,$5B,$19
 GOSUB LCDREG,$5C,$17
 GOSUB LCDREG,$5D,$FF

 GOSUB LCDREG,$17,$55

 IF HV THEN
  DX=240:DY=400
  GOSUB LCDREG,$16,$0B
 ELSE
  DX=400:DY=240
  GOSUB LCDREG,$16,$0A
 ENDIF

 GOSUB LCDREG,$28,$20
 WAIT 3
 GOSUB LCDREG,$28,$38
 WAIT 3
 GOSUB LCDREG,$28,$3C
 WAIT 3
RETURN

LABEL CVT565
 REM Convert 24bit Color to 16bit Color(565)
 VAR C
 C=ARGS(1)
 RETURN ((C AND $F80000)>>8)+((C AND $FC00)>>5)+((C AND $F8)>>3)

LABEL DOT565
 VAR X,Y
 X=ARGS(1):Y=ARGS(2)
 IF X>=0 AND X<DX AND Y>=0 AND Y<DY THEN
  GOSUB LCDADR,X,Y,1,1
  POKE16 LATB,ARGS(3)
  POKE16 LATDST,RSBIT
  POKE16 LATDCL,WRBIT:POKE16 LATDST,WRBIT
 ENDIF
RETURN

LABEL HLINE
 REM Draw Horizontal Line
 REM StartX,StartY,Length,Color(565)
 VAR X,Y,T,C,I
 X=ARGS(1):Y=ARGS(2):T=ARGS(3)
 IF Y<0 OR Y>=DY THEN RETURN
 IF X<0 THEN T=T+X:X=0
 IF T<=0 THEN RETURN
 IF X+T>DX THEN T=DX-X
 C=ARGS(4)
 GOSUB LCDADR,X,Y,T,1
 POKE16 LATDST,RSBIT
 POKE16 LATB,C
 FOR I=1 TO T
  POKE16 LATDCL,WRBIT:POKE16 LATDST,WRBIT
 NEXT
RETURN

LABEL LCDADR
 VAR X,Y,U,V
 X=ARGS(1):Y=ARGS(2)
 U=X+ARGS(3)-1:V=Y+ARGS(4)-1
 IF HV THEN
  GOSUB LCDREG,$02,X>>8
  GOSUB LCDREG,$03,X
  GOSUB LCDREG,$04,U>>8
  GOSUB LCDREG,$05,U
  GOSUB LCDREG,$06,Y>>8
  GOSUB LCDREG,$07,Y
  GOSUB LCDREG,$08,V>>8
  GOSUB LCDREG,$09,V
  GOSUB LCDREG,$80,X>>8
  GOSUB LCDREG,$81,X
  GOSUB LCDREG,$82,Y>>8
  GOSUB LCDREG,$83,Y
 ELSE
  GOSUB LCDREG,$02,Y>>8
  GOSUB LCDREG,$03,Y
  GOSUB LCDREG,$04,V>>8
  GOSUB LCDREG,$05,V
  GOSUB LCDREG,$06,X>>8
  GOSUB LCDREG,$07,X
  GOSUB LCDREG,$08,U>>8
  GOSUB LCDREG,$09,U
  GOSUB LCDREG,$80,Y>>8
  GOSUB LCDREG,$81,Y
  GOSUB LCDREG,$82,X>>8
  GOSUB LCDREG,$83,X
 ENDIF
 GOSUB LCDCOM,$22
RETURN

LABEL LCDREG
 GOSUB LCDCOM,ARGS(1)
 GOSUB LCDDAT,ARGS(2)
RETURN

LABEL LCDCOM
 POKE16 LATDCL,RSBIT
 POKE LATB,ARGS(1)
 POKE16 LATDCL,WRBIT
 POKE16 LATDST,WRBIT
RETURN

LABEL LCDDAT
 POKE16 LATDST,RSBIT
 POKE LATB,ARGS(1)
 POKE16 LATDCL,WRBIT
 POKE16 LATDST,WRBIT
RETURN
