REM QVGA LCD Controller ILI9341(SPI) Class
REM SP9341.BAS

REM Pin Assign
REM  MISO --> MISO(F2)
REM  MOSI --> MOSI(G9)
REM  CS   --> SCS(D9)
REM  CK   --> SCK(F6)
REM  D/C,RST : Remappable

REM Usage:
REM A=NEW(SP9341,HV,DC,RST)
REM A=NEW(SP9341,HV,DC,RST,FQ)
REM  Init LCD and Assign Control pins port
REM  HV 0:Horizontal other:Vertical
REM  DC,RST Port Number (0 to 15)
REM  FQ SPI's Frequency[KHz] (Default:10000KHz)

REM Color Format is 24bit RGB ($RRGGBB)
REM  but converted to 16bit color inside
REM  (RGB565 format)

REM Public Methods List
REM CLR()
REM  Clear LCD
REM DOT(X,Y,Color)
REM  Put dot
REM LIN(X1,Y1,X2,Y2,Color)
REM  Draw line
REM BOX(X1,Y1,X2,Y2,Color)
REM  Draw rectangular
REM BOXF(X1,Y1,X2,Y2,Color)
REM  Draw filled rectangular
REM CIR(X,Y,r,Color)
REM  Draw circle
REM CIRF(X,Y,r,Color)
REM  Draw filled circle
REM PRT(X,Y,Color,Background color,String)
REM  Draw string with System font
REM  Negative Background means transparent

OPTION NOLINENUM
FIELD PRIVATE HV,DC,RST,DX,DY,DCBIT
USEVAR LATB
USEVAR LATBCL
USEVAR LATBST

METHOD DOT
 GOSUB DOT565,ARGS(1),ARGS(2),GOSUB(CVT565,ARGS(3))
RETURN

METHOD LIN
 VAR X,Y,U,V,P,Q,I,E,C
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(5))
 P=ARGS(3)-X:U=1
 IF P<0 THEN P=-P:U=-1
 Q=ARGS(4)-Y:V=1
 IF Q<0 THEN Q=-Q:V=-1
 IF P>=Q THEN
  E=-P
  FOR I=0 TO P
   GOSUB DOT565,X,Y,C
   X=X+U:E=E+Q*2
   IF E>=0 THEN Y=Y+V:E=E-P*2
  NEXT
 ELSE
  E=-Q
  FOR I=0 TO Q
   GOSUB DOT565,X,Y,C
   Y=Y+V:E=E+P*2
   IF E>=0 THEN X=X+U:E=E-Q*2
  NEXT
 ENDIF
RETURN

METHOD BOX
 VAR C,X,Y,U,V
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 C=ARGS(5)
 GOSUB LIN,X,Y,X,V,C
 GOSUB LIN,U,Y,U,V,C
 GOSUB LIN,X,Y,U,Y,C
 GOSUB LIN,X,V,U,V,C
RETURN

METHOD BOXF
 VAR X,Y,U,V,T,C
 X=ARGS(1):Y=ARGS(2):U=ARGS(3):V=ARGS(4)
 IF X>U THEN T=U:U=X:X=T
 IF Y>V THEN T=V:V=Y:Y=T
 IF U<0 OR V<0 OR X>=DX OR Y>=DY THEN RETURN
 IF X<0 THEN X=0
 IF Y<0 THEN Y=0
 IF U>=DX THEN U=DX-1
 IF V>=DY THEN V=DY-1
 T=U-X+1
 C=GOSUB(CVT565,ARGS(5))
 WHILE Y<=V
  GOSUB HLINE,X,Y,T,C
  Y=Y+1
 WEND
RETURN

METHOD CIR
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB DOT565,U-X,V-Y,C
  GOSUB DOT565,U-X,V+Y,C
  GOSUB DOT565,U+X,V-Y,C
  GOSUB DOT565,U+X,V+Y,C
  GOSUB DOT565,U-Y,V-X,C
  GOSUB DOT565,U-Y,V+X,C
  GOSUB DOT565,U+Y,V-X,C
  GOSUB DOT565,U+Y,V+X,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CIRF
 VAR X,Y,U,V,C,F
 U=ARGS(1):V=ARGS(2)
 C=GOSUB(CVT565,ARGS(4))
 X=ARGS(3):Y=0:F=-2*X+3
 WHILE X>=Y
  GOSUB HLINE,U-X,V-Y,X*2+1,C
  GOSUB HLINE,U-X,V+Y,X*2+1,C
  GOSUB HLINE,U-Y,V-X,Y*2+1,C
  GOSUB HLINE,U-Y,V+X,Y*2+1,C
  IF F>=0 THEN X=X-1:F=F-X*4
  Y=Y+1:F=F+Y*4+2
 WEND
RETURN

METHOD CLR
 VAR Y
 FOR Y=0 TO DY-1
  GOSUB HLINE,0,Y,DX,0
 NEXT
RETURN

METHOD PRT
 REM PRT,X,Y,C,BC,S$
 VAR X,Y,C,B,S,A,I,J,P,D
 X=ARGS(1):Y=ARGS(2)
 C=GOSUB(CVT565,ARGS(3))
 B=ARGS(4):IF B>=0 THEN B=GOSUB(CVT565,B)
 S=ARGS(5)
 DO
  A=PEEK(S):IF A=0 THEN BREAK
  P=SYSTEM(103)+A*8:REM System Font Address
  FOR I=0 TO 7
   D=PEEK(P)
   FOR J=0 TO 7
    IF D AND $80 THEN
     GOSUB DOT565,X,Y,C
    ELSEIF B>=0 THEN
     GOSUB DOT565,X,Y,B
    ENDIF
    X=X+1:D=D<<1
   NEXT
   P=P+1:X=X-8:Y=Y+1
  NEXT
  X=X+8:Y=Y-8:S=S+1
 LOOP
RETURN

METHOD INIT
 HV=ARGS(1):DC=ARGS(2):RST=ARGS(3)
 LATB=$BF886130
 LATBCL=$BF886134
 LATBST=$BF886138
 DCBIT=1<<DC

 IF ARGS(0)>=4 THEN
  SPI ARGS(4)
 ELSE
  SPI 10000,8
 ENDIF

 OUT DC,1
 OUT RST,1
 WAIT 2
 OUT RST,0
 WAIT 2
 OUT RST,1
 WAIT 10

 GOSUB LCDCOM,$CB
 GOSUB LCDDAT,$39
 GOSUB LCDDAT,$2C
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$34
 GOSUB LCDDAT,$02
 GOSUB LCDCOM,$CF
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$C1
 GOSUB LCDDAT,$30
 GOSUB LCDCOM,$E8
 GOSUB LCDDAT,$85
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$78
 GOSUB LCDCOM,$EA
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$00
 GOSUB LCDCOM,$ED
 GOSUB LCDDAT,$64
 GOSUB LCDDAT,$03
 GOSUB LCDDAT,$12
 GOSUB LCDDAT,$81
 GOSUB LCDCOM,$F7
 GOSUB LCDDAT,$20

 GOSUB LCDCOM,$C0
 GOSUB LCDDAT,$23
 GOSUB LCDCOM,$C1
 GOSUB LCDDAT,$10
 GOSUB LCDCOM,$C5
 GOSUB LCDDAT,$3E
 GOSUB LCDDAT,$28
 GOSUB LCDCOM,$C7
 GOSUB LCDDAT,$86

 GOSUB LCDCOM,$36
 IF HV THEN
  GOSUB LCDDAT,$48
  DX=240:DY=320
 ELSE
  GOSUB LCDDAT,$0C
  DX=320:DY=240
 ENDIF

 GOSUB LCDCOM,$37
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$00
 GOSUB LCDCOM,$3A
 GOSUB LCDDAT,$55
 GOSUB LCDCOM,$B1
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$18
 GOSUB LCDCOM,$B6
 GOSUB LCDDAT,$0A
 GOSUB LCDDAT,$82
 GOSUB LCDDAT,$27
 GOSUB LCDDAT,$00
 GOSUB LCDCOM,$26
 GOSUB LCDDAT,$01
 GOSUB LCDCOM,$E0
 GOSUB LCDDAT,$0F
 GOSUB LCDDAT,$31
 GOSUB LCDDAT,$2B
 GOSUB LCDDAT,$0C
 GOSUB LCDDAT,$0E
 GOSUB LCDDAT,$08
 GOSUB LCDDAT,$4E
 GOSUB LCDDAT,$F1
 GOSUB LCDDAT,$37
 GOSUB LCDDAT,$07
 GOSUB LCDDAT,$10
 GOSUB LCDDAT,$03
 GOSUB LCDDAT,$0E
 GOSUB LCDDAT,$09
 GOSUB LCDDAT,$00
 GOSUB LCDCOM,$E1
 GOSUB LCDDAT,$00
 GOSUB LCDDAT,$0E
 GOSUB LCDDAT,$14
 GOSUB LCDDAT,$03
 GOSUB LCDDAT,$11
 GOSUB LCDDAT,$07
 GOSUB LCDDAT,$31
 GOSUB LCDDAT,$C1
 GOSUB LCDDAT,$48
 GOSUB LCDDAT,$08
 GOSUB LCDDAT,$0F
 GOSUB LCDDAT,$0C
 GOSUB LCDDAT,$31
 GOSUB LCDDAT,$36
 GOSUB LCDDAT,$0F
 GOSUB LCDCOM,$11
 WAIT 8
 GOSUB LCDCOM,$29
 WAIT 1
RETURN

LABEL CVT565
 REM Convert 24bit Color to 16bit Color(565)
 VAR C
 C=ARGS(1)
 RETURN ((C AND $F80000)>>8)+((C AND $FC00)>>5)+((C AND $F8)>>3)

LABEL DOT565
 VAR X,Y
 X=ARGS(1):Y=ARGS(2)
 IF X>=0 AND X<DX AND Y>=0 AND Y<DY THEN
  GOSUB LCDADR,X,Y,1,1
  GOSUB LCDDT2,ARGS(3)
 ENDIF
RETURN

LABEL HLINE
 REM Draw Horizontal Line
 REM StartX,StartY,Length,Color(565)
 VAR X,Y,T,H,L,I
 X=ARGS(1):Y=ARGS(2):T=ARGS(3)
 IF Y<0 OR Y>=DY THEN RETURN
 IF X<0 THEN T=T+X:X=0
 IF T<=0 THEN RETURN
 IF X+T>DX THEN T=DX-X
 L=ARGS(4):H=L>>8
 GOSUB LCDADR,X,Y,T,1
 POKE16 LATBST,DCBIT
 FOR I=1 TO T:SPIWRITE H,L:NEXT
RETURN

LABEL LCDADR
 VAR X,Y,U,V
 X=ARGS(1):Y=ARGS(2)
 U=X+ARGS(3)-1:V=Y+ARGS(4)-1
 IF HV THEN
  GOSUB LCDCOM,$2A
  GOSUB LCDDT2,X
  GOSUB LCDDT2,U
  GOSUB LCDCOM,$2B
  GOSUB LCDDT2,Y
  GOSUB LCDDT2,V
 ELSE
  GOSUB LCDCOM,$2A
  GOSUB LCDDT2,Y
  GOSUB LCDDT2,V
  GOSUB LCDCOM,$2B
  GOSUB LCDDT2,X
  GOSUB LCDDT2,U
 ENDIF
 GOSUB LCDCOM,$2C
RETURN

LABEL LCDCOM
 POKE16 LATBCL,DCBIT
 SPIWRITE ARGS(1)
RETURN

LABEL LCDDAT
 POKE16 LATBST,DCBIT
 SPIWRITE ARGS(1)
RETURN

LABEL LCDDT2
 POKE16 LATBST,DCBIT
 SPIWRITE ARGS(1)>>8,ARGS(1)
RETURN
