REM WS2812B Serial LED Control Class
REM WS2812.BAS

REM Connection:
REM  MachiKania    WS2818B
REM   D10/PWM1  --  DIN
REM   GND       --  GND

REM Usage:
REM A=NEW(WS2812,N)
REM  Init Buffer & Strat DMA
REM  N:Number of LED

REM METHOD SETLED(Position,R,G,B)
REM  Set Serial LED Color
REM  Position:LED Number from the front
REM  R,G,B:Color (0-255)

REM METHOD _START()
REM  Restart DMA

REM METHOD _STOP()
REM  Stop DMA
REM  Must call this method before stop the running BASIC program.

REM METHOD CPYLED(Position1,Position2)
REM  Copy LED Color from Position1 to Postion2

REM Notice!
REM This Class uses DMA0, CORETIMER Interrupt,
REM Timer3 and OC3.
REM Do Not use SOUND, MUSIC, PLAYWAVE, PWM,
REM CORETIMER Interrupt in user Application.

FIELD PRIVATE DMABUF,NUMLED,_CHANG
USEVAR DMA0,OC3,TMR3
USEVAR RESTIM,PERIOD,VAL0,VAL1,CTMRPR

METHOD INIT
 VAR I
 NUMLED=ARGS(1)
 RESTIM=292:PERIOD=92:VAL0=24:VAL1=62
  REM Reset time>280us, PERIOD=0.96us
  REM VAL0=0.25us, VAL1=0.65us

 CTMRPR=((PERIOD+2)*24*NUMLED+PERIOD*RESTIM)/2
 DIM DMABUF(NUMLED*24/4)
 FOR I=0 TO NUMLED*24-1:POKE DMABUF+I,VAL0:NEXT
 DMA0=$BF883060
 OC3 =$BF803400
 TMR3=$BF800A00
 GOSUB DMA_ON
RETURN

METHOD _START
 GOSUB DMA_ON
RETURN

LABEL DMA_ON
 PWM 1:REM Set OC3->D10 Pin / Set D10 Pin for Output

 POKE32 DMA0    ,$0000:REM DCH0CON
 POKE32 DMA0+$10,(14<<8)+$10:REM DMA Start by Timer3
 POKE32 DMA0+$20,0:REM DCH0INT
 POKE32 DMA0+$30,DMABUF AND $1FFFFFFF:REM Source Address=DMA Buffer
 POKE32 DMA0+$40,(OC3+$20) AND $1FFFFFFF:REM Destination Address=OC3RS
 POKE32 DMA0+$50,NUMLED*24+1:REM Source Size=DMA Buffer Size
 POKE32 DMA0+$60,1:REM DCH0DSIZ Destination Size=1
 POKE32 DMA0+$90,1:REM DCH0CSIZ Cell Size=1

 POKE32 OC3    ,0    :REM OC3CON
 POKE32 OC3+$10,0    :REM OC3R
 POKE32 OC3+$20,0    :REM OC3RS
 POKE32 OC3    ,$000E:REM OC3CON

 POKE32 TMR3    ,0     :REM T3CON
 POKE32 TMR3+$10,0     :REM TMR3
 POKE32 TMR3+$20,PERIOD:REM PR3

 POKE32 TMR3+8,$8000 :REM T3CONSET
 POKE32 OC3+8 ,$8000 :REM OC3CONSET

 _CHANG=1:GOSUB ISRCTM
 INTERRUPT CORETIMER,ISRCTM
RETURN

METHOD _STOP
 INTERRUPT STOP CORETIMER
 POKE32 DMA0,0
 PWM 0
 POKE32 TMR3,0
RETURN

METHOD SETLED
 REM SETLED(Position,R,G,B)
 VAR P,I,D
 IF ARGS(1)>=NUMLED THEN RETURN
 P=DMABUF+ARGS(1)*24
 D=(ARGS(3)<<24)+(ARGS(2)<<16)+(ARGS(4)<<8)
 FOR I=1 TO 24
  IF D<0 THEN POKE P,VAL1 ELSE POKE P,VAL0
  P=P+1:D=D<<1
 NEXT
 _CHANG=1
RETURN

METHOD CPYLED
 REM CPYLED(Position1,Position2)
 VAR I,P,Q
 IF ARGS(1)>=NUMLED THEN RETURN
 IF ARGS(2)>=NUMLED THEN RETURN
 P=DMABUF+ARGS(1)*24
 Q=DMABUF+ARGS(2)*24
 FOR I=0 TO 23 STEP 4
  POKE32 Q,PEEK32(P)
  P=P+4:Q=Q+4
 NEXT
 _CHANG=1
RETURN

LABEL ISRCTM
 REM CORETIMER Interrupt Service Routine
 REM Restart DMA if LED status changed
 IF _CHANG THEN
  POKE32 DMA0+8,$80:REM DCH0CONSET(Restart DMA)
  _CHANG=0
 ENDIF
 CORETIMER CORETIMER()+CTMRPR
RETURN
