// pbN}iLN^[x[Xj
// @with eLXgVRAMR|Wbgo̓VXe for PIC32MX1xx/2xx by K.Tanaka
// rev.2 PS/2L[{[hVXeɑΉ

#include <plib.h>
#include <stdlib.h>
#include "colortext32.h"
#include "pacman.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

_Character pacman,akabei,pinky,aosuke,guzuta; //eLN^[̍\
_Music music; //t̉y\
unsigned int score,highscore; //_AnCXRA
unsigned char player; //pbN}c
unsigned char stage; //݂̃Xe[W
unsigned char gamecount; //S̃JE^[
unsigned char gamestatus; //0:Q[X^[gA1:Q[A2:vC[1A3:Xe[WNAA4:Q[I[o[
unsigned char pacmanspeed,monsterspeed,ijikespeed,medamaspeed;//݂̃Xe[W̊eL̈ړxiJE^j
unsigned char ijiketime; //݂̃Xe[W̃CWP
unsigned char fruitno; //݂̃Xe[W̃t[cԍ
unsigned char upflag; //10000_z̃vC[`FbN
unsigned char fruitflag1,fruitflag2; //݂̃Xe[WŃt[cõtO
unsigned short fruitcount; //t[c\ԃJE^[
unsigned char cookie; //c
unsigned char huntedmonster; //CWP߂܂i_vZpj
unsigned char monsterhuntedtimer; //CWP߂܂ĂԂ̒~JE^[
unsigned char fruitscoretimer; //t[cl̓_\JE^[
unsigned char monstersoundcount; //X^[ʉ
unsigned char cookiesoundcount,fruitsoundcount,over10000soundcount;//eʉ̎
unsigned short monstersound,monstersounddif; //X^[ʉ̒lƑli[hɂقȂj
unsigned short monsterhuntedsound; //CWPߊlʉ̒l
unsigned short fruitsound; //t[clʉ
unsigned char map[MAPXSIZE*MAPYSIZE]; // ʘHAǁAAp[At[cAhA邱Ƃ\
unsigned char fruit[]={0,1,2,2,3,3,4,4,5,5,6,6,7}; //ʂƂ̃t[cԍ
unsigned short fruitscore[]={10,30,50,70,100,200,300,500}; //t[c̓_
unsigned char fruitcolor[]={2,2,COLOR_ORANGE,2,4,6,6,6}; //t[c̐Fԍ
unsigned char pacmansp[]= {15,14,14,14,13,13,13,12,12,12,11,11,11,10,10,10,10, 9, 9, 9, 9}; //ʂƂ̃pbN}x
unsigned char monstersp[]={15,14,14,14,13,13,13,12,12,12,11,11,11,10,10,10,10, 9, 9, 9, 9}; //ʂƂ̃X^[x
unsigned char ijikesp[]=  {37,35,35,35,32,32,32,30,30,30,27,27,27,25,25,25,25,22,22,22,22}; //ʂƂ̃CWPx
unsigned char ijike[]=    {15,15,12,10, 4, 9, 4, 4, 2,10, 4, 2, 2, 7, 2, 2, 0, 2, 0, 0, 0}; //ʂƂ̃CWP
unsigned char medamasp[]= { 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}; //ʂƂ̖ڋʑx

//sounddataz@h`̃h`̏̃h̎JE^lAPR3ɏނƉݒ肳
unsigned short sounddata[]={27363,25828,24378,23010,21718,20499,19349,18263,17238,16270,15357,14495,
						13681,12914,12189,11505,10859,10249,9674,9131,8619,8135,7678,7247,6840};
//musicdataz@K,,K,,EEEEE@ŌɉK254ŋȏI
//				K@0:h`12:̃h`24:̏̃h@@255:x
//				@60nb
unsigned char musicdata1[]={0,3,12,5,19,8,16,8,0,3,12,8,0,3,19,5,16,8,12,8,255,8,
						1,3,13,5,20,8,17,8,1,3,13,8,1,3,20,5,17,8,13,8,255,8,
						0,3,12,5,19,8,16,8,0,3,12,8,0,3,19,5,16,8,12,8,255,8,
						7,3,17,5,18,8,9,3,19,5,20,8,11,3,21,5,23,8,12,3,24,5,254};
unsigned char musicdata2[]={6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,10,16,
						6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,3,16,
						6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,9,8,11,8,
						12,8,11,8,9,8,6,8,9,8,6,16,255,8,
						6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,10,16,
						6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,3,16,
						6,6,255,2,6,6,255,2,6,8,3,4,1,4,6,2,255,2,6,12,9,8,11,8,
						12,8,11,8,9,8,6,8,9,8,6,16,254};
//
//}bv`
unsigned char scenedata[MAPXSIZE*MAPYSIZE]={
	//ǂƂ̔zu 0x80`0x8e:ǁA0x8f:ȂiʘHjA0x90:A0x91:p[
	0x80,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x8a,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x81,
	0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,
	0x85,0x90,0x80,0x84,0x81,0x90,0x80,0x84,0x81,0x90,0x85,0x90,0x80,0x84,0x81,0x90,0x80,0x84,0x81,0x90,0x85,
	0x85,0x91,0x85,0x8f,0x85,0x90,0x85,0x8f,0x85,0x90,0x85,0x90,0x85,0x8f,0x85,0x90,0x85,0x8f,0x85,0x91,0x85,
	0x85,0x90,0x82,0x84,0x83,0x90,0x82,0x84,0x83,0x90,0x86,0x90,0x82,0x84,0x83,0x90,0x82,0x84,0x83,0x90,0x85,
	0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,
	0x85,0x90,0x80,0x84,0x81,0x90,0x87,0x90,0x80,0x84,0x84,0x84,0x81,0x90,0x87,0x90,0x80,0x84,0x81,0x90,0x85,
	0x85,0x90,0x82,0x84,0x83,0x90,0x85,0x90,0x82,0x84,0x8a,0x84,0x83,0x90,0x85,0x90,0x82,0x84,0x83,0x90,0x85,
	0x85,0x90,0x90,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x90,0x90,0x85,
	0x82,0x84,0x84,0x84,0x81,0x90,0x8d,0x84,0x89,0x90,0x86,0x90,0x88,0x84,0x8c,0x90,0x80,0x84,0x84,0x84,0x83,
	0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,
	0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x80,0x84,0x8e,0x84,0x81,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,
	0x88,0x84,0x84,0x84,0x83,0x90,0x86,0x8f,0x85,0x8f,0x8f,0x8f,0x85,0x8f,0x86,0x90,0x82,0x84,0x84,0x84,0x89,
	0x8f,0x8f,0x8f,0x8f,0x8f,0x90,0x8f,0x8f,0x85,0x8f,0x8f,0x8f,0x85,0x8f,0x8f,0x90,0x8f,0x8f,0x8f,0x8f,0x8f,
	0x88,0x84,0x84,0x84,0x81,0x90,0x87,0x8f,0x82,0x84,0x84,0x84,0x83,0x8f,0x87,0x90,0x80,0x84,0x84,0x84,0x89,
	0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,
	0x8f,0x8f,0x8f,0x8f,0x85,0x90,0x85,0x8f,0x80,0x84,0x84,0x84,0x81,0x8f,0x85,0x90,0x85,0x8f,0x8f,0x8f,0x8f,
	0x80,0x84,0x84,0x84,0x83,0x90,0x86,0x8f,0x82,0x84,0x8a,0x84,0x83,0x8f,0x86,0x90,0x82,0x84,0x84,0x84,0x81,
	0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,
	0x85,0x90,0x88,0x84,0x81,0x90,0x88,0x84,0x89,0x90,0x86,0x90,0x88,0x84,0x89,0x90,0x80,0x84,0x89,0x90,0x85,
	0x85,0x91,0x90,0x90,0x85,0x90,0x90,0x90,0x90,0x90,0x8f,0x90,0x90,0x90,0x90,0x90,0x85,0x90,0x90,0x91,0x85,
	0x8d,0x84,0x81,0x90,0x85,0x90,0x87,0x90,0x80,0x84,0x84,0x84,0x81,0x90,0x87,0x90,0x85,0x90,0x80,0x84,0x8c,
	0x8d,0x84,0x83,0x90,0x86,0x90,0x85,0x90,0x82,0x84,0x8a,0x84,0x83,0x90,0x85,0x90,0x86,0x90,0x82,0x84,0x8c,
	0x85,0x90,0x90,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x85,0x90,0x90,0x90,0x90,0x90,0x85,
	0x85,0x90,0x88,0x84,0x84,0x84,0x8b,0x84,0x89,0x90,0x86,0x90,0x88,0x84,0x8b,0x84,0x84,0x84,0x89,0x90,0x85,
	0x85,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x85,
	0x82,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x83
};

//}Nݒ@z}bv̓ǂݏoA
#define GETMAP(x,y) map[(y)*MAPXSIZE+(x)]
#define SETMAP(x,y,d) map[(y)*MAPXSIZE+(x)]=(d)

void wait60thsec(unsigned short n){
	// 60nbEFCgirfIʂ̍ŉsMo͏I܂ő҂j
	drawcount=0;
	while(drawcount<n) asm("wait");
}
unsigned char startkeycheck(unsigned short n){
	// 60nbEFCg
	// X^[g{^΂߂
	//@߂l@X^[g{^1AȂ0
	drawcount=0;
	while(drawcount<n){
		if(~KEYPORT & KEYSTART) return 1;
		asm("wait");
	}
	return 0;
}
void playmusic60thsec(void){
	//601bEFCgA݉t̋Ȃ1i߂
	wait60thsec(1); //601bEFCg
	if(music.stop) return; //tIς
	music.count--;
	if(music.count>0) return;

	//̉炷
	if(*music.p==254){ //ȏI
		music.stop=1;
		PR3=0;
		return;
	}
	if(*music.p==255) PR3=0; //x
	else PR3=sounddata[*music.p]; //f[^
	music.p++;
	music.count=*music.p; //
	music.p++;
}
void startmusic(unsigned char *m){
	music.p=m;
	music.count=1;
	music.stop=0;
}
/*
//@Pɋȉt@i͖gpj
void playmusic(unsigned char *m){
	startmusic(m);
	while(music.stop==0){
		playmusic60thsec();
	}
}	
*/
void printchar(unsigned char x,unsigned char y,unsigned char c,unsigned char n){
	//W(x,y)ɃJ[ԍcŃeLXgR[hn1\
	unsigned char *p;
	p=TVRAM+y*WIDTH_X+x;
	*p=n;
	*(p+ATTROFFSET)=c;
}
void printstr(unsigned char x,unsigned char y,unsigned char c,unsigned char *s){
	//W(x,y)J[ԍcŕs\
	unsigned char *p;
	p=TVRAM+y*WIDTH_X+x;
	while(*s){
		*(p+ATTROFFSET)=c;
		*p++=*s++;
	}
}
void printscore(unsigned char x,unsigned char y,unsigned char c,unsigned int s){
	//W(x,y)ɃJ[ԍcœ_s\i5j
	x+=5;
	do{
		printchar(x,y,c,'0'+s%10);
		s/=10;
		x--;
	}while(s!=0);
}

void putpacman(void){
	//pbN}̕\
	pacman.animcount--;
	if(pacman.animcount==0){
		pacman.animcount=pacman.animcount0;
		pacman.animvalue++;
		if(pacman.animvalue==4) pacman.animvalue=0;
	}
	printchar(pacman.x,pacman.y,6,CODE_PACMAN+pacman.dir*4+pacman.animvalue);
}
void putmonster(_Character *p,unsigned char c){
	//X^[\@p:LN^[̃|C^wAc:\F
	switch(p->status){
		case IJIKE:
			if(p->modecount>3 || gamecount & 8)
				printchar(p->x,p->y,COLOR_IJIKE,CODE_IJIKE);
			else
				//œ_
				printchar(p->x,p->y,COLOR_IJIKE2,CODE_IJIKE);
			break;
		case MEDAMA:
			printchar(p->x,p->y,COLOR_MEDAMA,CODE_MEDAMA+p->dir);
			break;
		default:
			printchar(p->x,p->y,c,CODE_MONSTER+p->dir);
	}
}
void blinkpowercookie(){
	//p[̓_
	if(gamecount & 0x10){
		set_palette(COLOR_POWERCOOKIE,0,50,50);
	}
	else{
		set_palette(COLOR_POWERCOOKIE,0,255,255);
	}
}
unsigned char getfruitno(unsigned char s){
	// sʂ̃t[cԍԂ
	if(s<13) return fruit[s-1];
	else return fruit[12];
}
void putfruit(void){
	// t[c\
	printchar(FRUITX,FRUITY,fruitcolor[fruitno],CODE_FRUIT+fruitno);
}
void setfruit(unsigned char f){
	// f 0:t[c폜&\A1:t[c&\
	if(f){
		SETMAP(FRUITX,FRUITY,MAP_FRUIT);
		putfruit();
	}
	else{
		SETMAP(FRUITX,FRUITY,MAP_NONE);
		printchar(FRUITX,FRUITY,0,' ');
	}
}
void getfruit(){
	// t[cHׂ

	score+=fruitscore[fruitno];
	fruitcount=0;
	setfruit(0);
	fruitsound=22000;
	fruitsoundcount=20;
	fruitscoretimer=TIMER_FRUITSCORE;
}

void putmapchar(unsigned char x,unsigned char y){
	//}bṽR[hɉ̂\
	unsigned char d;

	d=GETMAP(x,y);
	if(d==MAP_COOKIE) printchar(x,y,COLOR_COOKIE,CODE_COOKIE);
	else if(d==MAP_POWERCOOKIE) printchar(x,y,COLOR_POWERCOOKIE,CODE_POWERCOOKIE);
	else if(d==MAP_FRUIT) putfruit();
	else if(d==MAP_DOOR) printchar(x,y,COLOR_DOOR,CODE_DOOR);
	else printchar(x,y,0,' ');
}
void displayscore(){
	if(score>highscore) highscore=score;
	printscore(21,3,7,highscore);
	printscore(21,7,7,score);
}
void writehighscore(void){
	//nCXRÃtbV
	stop_composite();//\~
	NVMErasePage((void *)FLASHPAGE);//y[W
	NVMWriteWord((void *)FLASHPAGE,highscore);//[h
	start_composite();//\Jn
}
void displayplayers(){
	//vC[c\
	unsigned char i;
	for(i=0;i<player && i<8;i++) printchar(22+i,23,COLOR_PACMAN,0x92);
	for(;i<8;i++) printchar(22+i,23,0,' ');
}
void displayfruits(){
	//ʉE7Xe[W̃t[c\
	unsigned char i,no;
	for(i=0;i<7 && i<stage;i++){
		no=getfruitno(stage-i);
		printchar(22+i,15,fruitcolor[no],CODE_FRUIT+no);
	}
}
void putmap(void){
	//ʘHAAp[̕\
	unsigned char c,*p,*mapp;
	int i,j,k;
	clearscreen();
	p=scenedata;
	mapp=map;
	cookie=0;
	for(i=0;i<MAPYSIZE;i++){
		for(j=0;j<MAPXSIZE;j++){
			if(*p<=0x8d){
				*mapp=MAP_WALL; //
				printchar(j,i,COLOR_WALL,*p);
			}
			else if(*p==CODE_DOOR){
				*mapp=MAP_DOOR; //hA
				printchar(j,i,COLOR_DOOR,CODE_DOOR);
			}
			else if(*p==CODE_COOKIE){
				*mapp=MAP_COOKIE; //
				printchar(j,i,COLOR_COOKIE,CODE_COOKIE);
				cookie++;
			}
			else if(*p==CODE_POWERCOOKIE){
				*mapp=MAP_POWERCOOKIE; //p[
				printchar(j,i,COLOR_POWERCOOKIE,CODE_POWERCOOKIE);
				cookie++;
			}
			else *mapp=0;
			p++;
			mapp++;
		}
	}
	printstr(21,1,7,"HI-SCORE");
	printchar(27,3,7,'0');
	printstr(22,5,7,"1UP");
	printchar(27,7,7,'0');
	displayscore();
	displayplayers();
	displayfruits();
}
void initcharacter(_Character *p,unsigned char s,unsigned char x,unsigned char y,
					unsigned char dir,unsigned char mc,unsigned char ac,unsigned short modec)
{
	//LN^[
	//p:LN^[̃|C^As:[histatusjAix,y):ʒuAdir:
	//mc:ړJE^Aac:Aj[VJE^AmodecF[hJE^[
	p->status=s;
	p->x=x;
	p->y=y;
	p->oldx=x;
	p->oldy=y;
	p->dir=dir;
	p->movecount=mc;
	p->animcount=ac;
	p->animcount0=ac;
	p->animvalue=0;
	p->modecount=modec;
}

void gameinit(void)
{
// Q[Ŝ̏BN1񂾂
	set_palette(COLOR_GUZUTA,70,200,128); //OY^̐F
	set_palette(COLOR_PINKY,180,230,128); //sL[̐F
	set_palette(COLOR_WALL,250,20,40); //ǂ̐F
	set_palette(COLOR_POWERCOOKIE,0,255,255); //p[̐F
	set_palette(COLOR_ORANGE,0,255,165); //݂̐F
	set_palette(COLOR_MONSTERNUDE,180,245,220); //̃X^[̐F
	if(*(unsigned int *)FLASHPAGE==-1){ //tbVɃnCXRA܂Ă邩`FbN
		highscore=1000;
		writehighscore();
	}
	else highscore=*(unsigned int *)FLASHPAGE;
	score=0;
}
void gameinit2(void)
{
// Q[BvC{^ŖĂяo
	score=0;
	player=3;
	upflag=0;//1000_zŃvC[+1̃`FbNp
	stage=0;
}
void gameinit3(void)
{
// V[NAƂɌĂяo
	if(stage<STAGEMAX-1){
		ijiketime=ijike[stage];
		pacmanspeed=pacmansp[stage];
		monsterspeed=monstersp[stage];
		ijikespeed=ijikesp[stage];
		medamaspeed=medamasp[stage];
	}
	else{
		ijiketime=ijike[STAGEMAX-1];
		pacmanspeed=pacmansp[STAGEMAX-1];
		monsterspeed=monstersp[STAGEMAX-1];
		ijikespeed=ijikesp[STAGEMAX-1];
		medamaspeed=medamasp[STAGEMAX-1];
	}
	stage++;
	fruitflag1=1;//ʑÕt[ccĂ
	fruitflag2=1;//ʌ㔼̃t[ccĂ
	fruitno=getfruitno(stage);
	putmap();//ʘH̕\
}
void gameinit4(void)
{
// pbN}邲ƁAуV[NAƂɌĂяo
	fruitcount=0;
	fruitscoretimer=0;
	huntedmonster=0;
	monsterhuntedtimer=0;
	monstersoundcount=0;
	cookiesoundcount=0;
	fruitsoundcount=0;
	over10000soundcount=0;
	setfruit(0);//t[c폜A\
	initcharacter(&pacman,0,10,20,DIR_LEFT,pacmanspeed,5,0);
	initcharacter(&akabei,NAWABARI,MONSTERHOUSEX,MONSTERHOUSEY-2,DIR_LEFT,monsterspeed,5,35);
	initcharacter(&pinky ,NAWABARI,MONSTERHOUSEX,MONSTERHOUSEY+1,DIR_UP,monsterspeed,5,0);
	initcharacter(&aosuke,TAIKI2,MONSTERHOUSEX-1,MONSTERHOUSEY+1,DIR_DOWN,monsterspeed,5,25);
	initcharacter(&guzuta,TAIKI2,MONSTERHOUSEX+1,MONSTERHOUSEY+1,DIR_DOWN,monsterspeed,5,40);
}

void keycheck()
{
	// {^`FbNAǂłȂ΃pbN}̌ύX
	unsigned short k;
	unsigned char d;

	k=~KEYPORT & (KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT);
	if(k==KEYUP){	//{^
		if(pacman.dir!=DIR_UP){
			if(pacman.y!=0){
				if(GETMAP(pacman.x,pacman.y-1)!=MAP_WALL) pacman.dir=DIR_UP;
			}
			else pacman.dir=DIR_UP;
		}
	}
	else if(k==KEYRIGHT){	//E{^
		if(pacman.dir!=DIR_RIGHT){
			if(pacman.x!=MAPXSIZE-1){
				if(GETMAP(pacman.x+1,pacman.y)!=MAP_WALL) pacman.dir=DIR_RIGHT;
			}
			else pacman.dir=DIR_RIGHT;
		}
	}
	else if(k==KEYDOWN){	//{^
		if(pacman.dir!=DIR_DOWN){
			if(pacman.y!=MAPYSIZE-1){
				d=GETMAP(pacman.x,pacman.y+1);
				if(d!=MAP_WALL && d!=MAP_DOOR) pacman.dir=DIR_DOWN;
			}
			else pacman.dir=DIR_DOWN;
		}
	}
	else if(k==KEYLEFT){	//{^
		if(pacman.dir!=DIR_LEFT){
			if(pacman.x!=0){
				if(GETMAP(pacman.x-1,pacman.y)!=MAP_WALL) pacman.dir=DIR_LEFT;
			}
			else pacman.dir=DIR_LEFT;
		}
	}
}

void movepacman(){
	//pbN}ړ`FbN
	unsigned char t;
	if(monsterhuntedtimer>0) return; //X^[ߊl͒~
	pacman.movecount--;
	if(pacman.movecount>0) return;
	pacman.movecount=pacmanspeed;
	pacman.oldx=pacman.x;
	pacman.oldy=pacman.y;
	switch(pacman.dir){
		case DIR_UP: //
			if(pacman.y!=0){
				if(GETMAP(pacman.x,pacman.y-1)!=MAP_WALL) pacman.y--;
			}
			else pacman.y=MAPYSIZE-1;
			break;
		case DIR_RIGHT: //E
			if(pacman.x!=MAPXSIZE-1){
				if(GETMAP(pacman.x+1,pacman.y)!=MAP_WALL) pacman.x++;
			}
			else pacman.x=0;
			break;
		case DIR_DOWN: //BX^[nEX̃hAǂƂ݂Ȃ
			if(pacman.y!=MAPYSIZE-1){
				t=GETMAP(pacman.x,pacman.y+1);
				if(t!=MAP_WALL && t!=MAP_DOOR) pacman.y++;
			}
			else pacman.y=0;
			break;
		case DIR_LEFT: //
			if(pacman.x!=0){
				if(GETMAP(pacman.x-1,pacman.y)!=MAP_WALL) pacman.x--;
			}
			else pacman.x=MAPXSIZE-1;
	}
}
void movemonster(_Character *p,unsigned char tx,unsigned char ty){
	//X^[̈ړ肵Aړ
	//p:X^[̃|C^Atx:ڕWxWAty:ڕWyW
	unsigned char cUP,cRIGHT,cDOWN,cLEFT;
	unsigned char t;
	unsigned char olddir;

	olddir=p->dir;
	//cUPAcRIGHTAcDOWNAcLEFT:ꂼ̕ɒʂꍇ1AʂȂꍇ0Ƃ
	cUP=1;
	cRIGHT=1;
	cDOWN=1;
	cLEFT=1;
	if(p->y!=0 && GETMAP(p->x,p->y-1)==MAP_WALL) cUP=0;
	//@ʍs`FbN
	else if(p->status!=MEDAMA &&
	  (p->x==ONEWAY1X && p->y==ONEWAY1Y+1 || p->x==ONEWAY2X && p->y==ONEWAY2Y+1 ||
	   p->x==ONEWAY3X && p->y==ONEWAY3Y+1 || p->x==ONEWAY4X && p->y==ONEWAY4Y+1)) cUP=0;
	if(p->x!=MAPXSIZE-1 && GETMAP(p->x+1,p->y)==MAP_WALL) cRIGHT=0;
	if(p->y!=MAPYSIZE-1){
		//ڋʂ̂ƂȊO̓hAǂƂ݂Ȃ
		t=GETMAP(p->x,p->y+1);
		if(t==MAP_WALL || (t==MAP_DOOR && p->status!=MEDAMA)) cDOWN=0;
	}
	if(p->x!=0 && GETMAP(p->x-1,p->y)==MAP_WALL) cLEFT=0;

	if(p->status==TAIKI2) p->dir=(p->dir+2)&3;//]
	else switch(p->dir){
		case DIR_UP: //is=EEED揇ʁ@Eと
			if(p->x<tx && cRIGHT) p->dir=DIR_RIGHT;
			else if(p->y>ty && cUP) p->dir=DIR_UP;
			else if(p->x>tx && cLEFT) p->dir=DIR_LEFT;
			else if(cRIGHT) p->dir=DIR_RIGHT;
			else if(cUP) p->dir=DIR_UP;
			else p->dir=DIR_LEFT;
			break;
		case DIR_RIGHT: //is=EEEED揇ʁ@E
			if(p->y<ty && cDOWN) p->dir=DIR_DOWN;
			else if(p->x<tx && cRIGHT) p->dir=DIR_RIGHT;
			else if(p->y>ty && cUP) p->dir=DIR_UP;
			else if(cDOWN) p->dir=DIR_DOWN;
			else if(cRIGHT) p->dir=DIR_RIGHT;
			else p->dir=DIR_UP;
			break;
		case DIR_DOWN: //is=EEED揇ʁ@E
			if(p->x>tx && cLEFT) p->dir=DIR_LEFT;
			else if(p->y<ty && cDOWN) p->dir=DIR_DOWN;
			else if(p->x<tx && cRIGHT) p->dir=DIR_RIGHT;
			else if(cLEFT) p->dir=DIR_LEFT;
			else if(cDOWN) p->dir=DIR_DOWN;
			else p->dir=DIR_RIGHT;
			break;
		case DIR_LEFT: //is=EEED揇ʁ@と
			if(p->y>ty && cUP) p->dir=DIR_UP;
			else if(p->x>tx && cLEFT) p->dir=DIR_LEFT;
			else if(p->y<ty && cDOWN) p->dir=DIR_DOWN;
			else if(cUP) p->dir=DIR_UP;
			else if(cLEFT) p->dir=DIR_LEFT;
			else p->dir=DIR_DOWN;
	}
	if(olddir!=p->dir) p->movecount+=2; //R[i[Ȃ鎞Ax
	p->oldx=p->x;
	p->oldy=p->y;
	switch(p->dir){
		case DIR_UP: //
			if(p->y!=0) p->y--;
			else p->y=MAPYSIZE-1;
			break;
		case DIR_RIGHT: //E
			if(p->x!=MAPXSIZE-1) p->x++;
			else p->x=0;
			break;
		case DIR_DOWN: //
			if(p->y!=MAPYSIZE-1) p->y++;
			else p->y=0;
			break;
		case DIR_LEFT: //
			if(p->x!=0) p->x--;
			else p->x=MAPXSIZE-1;
	}
	if(p->status!=MEDAMA){ //蔲ĂȂ`FbN
		if(p->x==pacman.oldx && p->y==pacman.oldy && p->oldx==pacman.x && p->oldy==pacman.y){
			p->x=p->oldx;
			p->y=p->oldy;
		}
	}
}

void moveakabei(){
	//AJxCړ
	unsigned char targetx,targety;

	if(monsterhuntedtimer>0 && akabei.status!=MEDAMA) return; //NߊlĂƂڋʈȊO͒~
	akabei.movecount--;
	if(akabei.movecount!=0) return;
	switch (akabei.status){
		case NAWABARI:
			akabei.movecount=monsterspeed;
			akabei.modecount--;
			if(akabei.modecount==0){
				akabei.modecount=TIMER_OIKAKE/monsterspeed;
				akabei.status=OIKAKE;
				akabei.dir=(akabei.dir+2)&3; //]
				//̃X^[ɕύX
				if(pinky.status==NAWABARI){
					pinky.status=OIKAKE;
					pinky.dir=(pinky.dir+2)&3;
				}
				if(aosuke.status==NAWABARI){
					aosuke.status=OIKAKE;
					aosuke.dir=(aosuke.dir+2)&3;
				}
				if(guzuta.status==NAWABARI){
					guzuta.status=OIKAKE;
					guzuta.dir=(guzuta.dir+2)&3;
				}
			}
			break;
		case OIKAKE:
			akabei.movecount=monsterspeed;
			akabei.modecount--;
			if(akabei.modecount==0){
				akabei.modecount=TIMER_NAWABARI/monsterspeed;
				akabei.status=NAWABARI;
				akabei.dir=(akabei.dir+2)&3; //]
				if(pinky.status==OIKAKE){
					pinky.status=NAWABARI;
					pinky.dir=(pinky.dir+2)&3;
				}
				if(aosuke.status==OIKAKE){
					aosuke.status=NAWABARI;
					aosuke.dir=(aosuke.dir+2)&3;
				}
				if(guzuta.status==OIKAKE){
					guzuta.status=NAWABARI;
					guzuta.dir=(guzuta.dir+2)&3;
				}
			}
			break;
		case IJIKE:
			akabei.modecount--;
			if(akabei.modecount==0){
				akabei.status=OIKAKE;
				akabei.modecount=TIMER_OIKAKE;
				akabei.movecount=monsterspeed;
			}
			else akabei.movecount=ijikespeed;
			break;
		case MEDAMA:
			if(akabei.x==MONSTERHOUSEX && akabei.y==MONSTERHOUSEY){ //X^[nEX
				akabei.status=TAIKI2;
				akabei.modecount=1;
				akabei.dir=DIR_UP;
				akabei.movecount=monsterspeed;
			}
			else akabei.movecount=medamaspeed;
			break;
		case TAIKI:
			akabei.movecount=monsterspeed;
			if(akabei.x==MONSTERHOUSEX && akabei.y==MONSTERHOUSEY-2){ //X^[nEXo
				akabei.status=OIKAKE;
				akabei.modecount=TIMER_OIKAKE/monsterspeed;
				akabei.dir=DIR_LEFT;
			}
			break;
		case TAIKI2:
			akabei.movecount=monsterspeed;
			akabei.modecount--;
			if(akabei.modecount==0){
				akabei.status=TAIKI;
			}
	}
	switch (akabei.status){
		case NAWABARI:
		case IJIKE:
			targetx=NAWABARIAKABEIX;
			targety=NAWABARIAKABEIY;
			break;
		case OIKAKE:
			targetx=pacman.x;
			targety=pacman.y;
			break;
		case MEDAMA:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case TAIKI:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY-2;
	}
	movemonster(&akabei,targetx,targety);
}

void movepinky(){
	//sL[ړ
	unsigned char targetx,targety;

	if(monsterhuntedtimer>0 && pinky.status!=MEDAMA) return; //NߊlĂƂڋʈȊO͒~
	pinky.movecount--;
	if(pinky.movecount!=0) return;
	switch (pinky.status){
		case NAWABARI:
		case OIKAKE:
			pinky.movecount=monsterspeed;
			break;
		case IJIKE:
			pinky.modecount--;
			if(pinky.modecount==0){
				pinky.status=OIKAKE;
				pinky.movecount=monsterspeed;
			}
			else pinky.movecount=ijikespeed;
			break;
		case MEDAMA:
			if(pinky.x==MONSTERHOUSEX && pinky.y==MONSTERHOUSEY){ //X^[nEX
				pinky.status=TAIKI2;
				pinky.modecount=1;
				pinky.dir=DIR_UP;
				pinky.movecount=monsterspeed;
			}
			else pinky.movecount=medamaspeed;
			break;
		case TAIKI:
			pinky.movecount=monsterspeed;
			if(pinky.x==MONSTERHOUSEX && pinky.y==MONSTERHOUSEY-2){ //X^[nEXo
				pinky.status=OIKAKE;
				pinky.dir=DIR_LEFT;
			}
			break;
		case TAIKI2:
			pinky.movecount=monsterspeed;
			pinky.modecount--;
			if(pinky.modecount==0){
				pinky.status=TAIKI;
			}
	}
	switch (pinky.status){
		case NAWABARI:
			targetx=NAWABARIPINKYX;
			targety=NAWABARIPINKYY;
			break;
		case IJIKE:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case OIKAKE: //pbN}̐is+3^[QbgWƂ
			if(pacman.dir==DIR_UP){
				targetx=pacman.x;
				if(pacman.y>=4) targety=pacman.y-3;
				else if(pacman.y==0) targety=MAPYSIZE-3;
				else targety=1;
			}
			else if(pacman.dir==DIR_RIGHT){
				targety=pacman.y;
				if(pacman.x<=MAPXSIZE-5) targetx=pacman.x+3;
				else if(pacman.x==MAPXSIZE-1) targetx=2;
				else targetx=MAPXSIZE-2;
			}
			else if(pacman.dir==DIR_DOWN){
				targetx=pacman.x;
				if(pacman.y<=MAPYSIZE-5) targety=pacman.y+3;
				else if(pacman.y==MAPYSIZE-1) targety=2;
				else targety=MAPYSIZE-2;
			}
			else if(pacman.dir==DIR_LEFT){
				targety=pacman.y;
				if(pacman.x>=4) targetx=pacman.x-3;
				else if(pacman.x==0) targetx=MAPXSIZE-3;
				else targetx=1;
			}
			break;
		case MEDAMA:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case TAIKI:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY-2;
	}
	movemonster(&pinky,targetx,targety);
}

void moveaosuke()
{
	//AIXPړ
	unsigned char targetx,targety;

	if(monsterhuntedtimer>0 && aosuke.status!=MEDAMA) return; //NߊlĂƂڋʈȊO͒~
	aosuke.movecount--;
	if(aosuke.movecount!=0) return;
	switch (aosuke.status){
		case NAWABARI:
		case OIKAKE:
			aosuke.movecount=monsterspeed;
			break;
		case IJIKE:
			aosuke.modecount--;
			if(aosuke.modecount==0){
				aosuke.status=OIKAKE;
				aosuke.movecount=monsterspeed;
			}
			else aosuke.movecount=ijikespeed;
			break;
		case MEDAMA:
			if(aosuke.x==MONSTERHOUSEX && aosuke.y==MONSTERHOUSEY){ //X^[nEX
				aosuke.status=TAIKI2;
				aosuke.modecount=1;
				aosuke.dir=DIR_UP;
				aosuke.movecount=monsterspeed;
			}
			else aosuke.movecount=medamaspeed;
			break;
		case TAIKI:
			aosuke.movecount=monsterspeed;
			if(aosuke.x==MONSTERHOUSEX && aosuke.y==MONSTERHOUSEY-2){ //X^[nEXo
				aosuke.status=OIKAKE;
				aosuke.dir=DIR_LEFT;
			}
			break;
		case TAIKI2:
			aosuke.movecount=monsterspeed;
			aosuke.modecount--;
			if(aosuke.modecount==0){
				aosuke.status=TAIKI;
			}
	}
	switch (aosuke.status){
		case NAWABARI:
			targetx=NAWABARIAOSUKEX;
			targety=NAWABARIAOSUKEY;
			break;
		case IJIKE:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case OIKAKE: //pbN}SɃAJxCƓ_Ώ̂̈ʒu^[QbgWƂ
			targetx=pacman.x*2-akabei.x;
			targety=pacman.y*2-akabei.y;
			if(targetx>=128) targetx=0;
			if(targety>=128) targety=0;
			break;
		case MEDAMA:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case TAIKI:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY-2;
	}
	movemonster(&aosuke,targetx,targety);
}

void moveguzuta()
{
	//OY^ړ
	unsigned char targetx,targety;
	short dx,dy;

	if(monsterhuntedtimer>0 && guzuta.status!=MEDAMA) return; //NߊlĂƂڋʈȊO͒~
	guzuta.movecount--;
	if(guzuta.movecount!=0) return;
	switch (guzuta.status){
		case NAWABARI:
		case OIKAKE:
			guzuta.movecount=monsterspeed;
			break;
		case IJIKE:
			guzuta.modecount--;
			if(guzuta.modecount==0){
				guzuta.status=OIKAKE;
				guzuta.movecount=monsterspeed;
			}
			else guzuta.movecount=ijikespeed;
			break;
		case MEDAMA:
			if(guzuta.x==MONSTERHOUSEX && guzuta.y==MONSTERHOUSEY){ //X^[nEX
				guzuta.status=TAIKI2;
				guzuta.modecount=1;
				guzuta.dir=DIR_UP;
				guzuta.movecount=monsterspeed;
			}
			else guzuta.movecount=medamaspeed;
			break;
		case TAIKI:
			guzuta.movecount=monsterspeed;
			if(guzuta.x==MONSTERHOUSEX && guzuta.y==MONSTERHOUSEY-2){ //X^[nEXo
				guzuta.status=OIKAKE;
				guzuta.dir=DIR_LEFT;
			}
			break;
		case TAIKI2:
			guzuta.movecount=monsterspeed;
			guzuta.modecount--;
			if(guzuta.modecount==0){
				guzuta.status=TAIKI;
			}
	}
	switch (guzuta.status){
		case NAWABARI:
			targetx=NAWABARIGUZUTAX;
			targety=NAWABARIGUZUTAY;
			break;
		case IJIKE:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case OIKAKE: //pbN}牓ɂƂ͋߂ÂĂ邪A߂Âƕʂڎw
			dx=(short)guzuta.x-(short)pacman.x;
			dy=(short)guzuta.y-(short)pacman.y;
			if(dx*dx+dy*dy>8){
				targetx=pacman.x;
				targety=pacman.y;
			}
			else{
				targetx=NAWABARIGUZUTAX;
				targety=NAWABARIGUZUTAY;
			}
			break;
		case MEDAMA:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY;
			break;
		case TAIKI:
			targetx=MONSTERHOUSEX;
			targety=MONSTERHOUSEY-2;
	}
	movemonster(&guzuta,targetx,targety);
}

void sound(void){
	//ʉo
	//601bƂɌĂяo
	//̂قŏ̂قǗDIɖ炷
	unsigned short pr;//^C}[JE^[l
	pr=0;

//X^[̉
	if(akabei.status==MEDAMA || pinky.status==MEDAMA || aosuke.status==MEDAMA || guzuta.status==MEDAMA){
	//ڋʁEEEpr2200`3000ŘAωAXs[hƕω
		if(monstersoundcount==0){
			monstersound=2200;
			monstersounddif=800/monsterspeed;
		}
		else monstersound+=monstersounddif;
		pr=monstersound;
		monstersoundcount++;
		if(monstersoundcount>monsterspeed) monstersoundcount=0;
	}
	else if(akabei.status==IJIKE || pinky.status==IJIKE || aosuke.status==IJIKE || guzuta.status==IJIKE){
	//CWPEEEpr7600`3800ŘAωAXs[hƕω
		if(monstersoundcount==0){
			monstersounddif=7600/monsterspeed;
			monstersound=3800+(monsterspeed>>1)*monstersounddif;
		}
		else monstersound-=monstersounddif;
		pr=monstersound;
		monstersoundcount++;
		if(monstersoundcount*2>monsterspeed) monstersoundcount=0;
	}
	else{
	//ʏ
		if(monstersoundcount==0){
			monstersound=2500+monsterspeed*60;
			monstersounddif=monstersound/monsterspeed;
		}
		else if(monstersoundcount<monsterspeed) monstersound+=monstersounddif;
		else monstersound-=monstersounddif;
		pr=monstersound;
		monstersoundcount++;
		if(monstersoundcount>monsterspeed*2) monstersoundcount=0;
	}

//Hׂ鉹
	if(cookiesoundcount!=0){
		if((cookie&1)==0){
			if(cookiesoundcount>3) pr=32000;
			else pr=16000;
		}
		else{
			if(cookiesoundcount>3) pr=16000;
			else pr=32000;
		}
		cookiesoundcount--;
	}
//t[cHׂ鉹0.3b
	if(fruitsoundcount!=0){
		pr=fruitsound;
		fruitsound-=670;
		fruitsoundcount--;
	}
//CWPHׂ鉹80/60bA8FAA21񉹂炵ύX
	if(monsterhuntedtimer>0){
		if(monsterhuntedtimer&1){
			pr=monsterhuntedsound;
			monsterhuntedsound-=40;
		}
	}
//10000_zApbN}+1 G8炷
	if(over10000soundcount!=0){
		if((over10000soundcount&7)<6) pr=4565;
		over10000soundcount--;
	}

	PR3=pr; //ۂɎύX
}
void erasechars(){
	// \̏i̕\ɖ߂j
	putmapchar(pacman.x,pacman.y);
	putmapchar(akabei.x,akabei.y);
	putmapchar(pinky.x,pinky.y);
	putmapchar(aosuke.x,aosuke.y);
	putmapchar(guzuta.x,guzuta.y);
}

void displaychars(){
	blinkpowercookie();
	putmonster(&akabei,COLOR_AKABEI);
	putmonster(&pinky,COLOR_PINKY);
	putmonster(&aosuke,COLOR_AOSUKE);
	putmonster(&guzuta,COLOR_GUZUTA);
	putpacman();

	//CWPHׂƂ̓_\
	if(monsterhuntedtimer!=0) printchar(pacman.x,pacman.y,7,0xb8+huntedmonster);
}
void fruitcheck(){
	//t[coAŃ`FbNA
	if(fruitflag1 && cookie==FRUITTIME1){
		fruitflag1=0;
		setfruit(1);
		fruitcount=TIMER_FRUIT;
	}
	else if(fruitflag2 && cookie==FRUITTIME2){
		fruitflag2=0;
		setfruit(1);
		fruitcount=TIMER_FRUIT;
	}
	else if(fruitcount>0){
		fruitcount--;
		if(fruitcount==0) setfruit(0);//Ԑ؂Ńt[c
	}
	else if(fruitscoretimer>0){ //t[cHׂƂ̃XRA\
		fruitscoretimer--;
		if(fruitscoretimer==0) printchar(FRUITX,FRUITY,0,' ');
		else printchar(FRUITX,FRUITY,7,CODE_FRUITSCORE+fruitno);
	}
}

void movechars(){
	//eLN^[̈ړ
	movepacman();
	moveakabei();
	movepinky();
	moveaosuke();
	moveguzuta();
	if(monsterhuntedtimer>0) monsterhuntedtimer--;
}

void setmonsterijike(_Character *p){
	// X^[Ԃɂ
	if(p->status==MEDAMA) return;
//	if(p->status==TAIKI || p->status==TAIKI2) return;
	p->dir=(p->dir+2)&3; //]
	if(ijiketime!=0){
		p->status=IJIKE;
		p->modecount=ijiketime;
		p->movecount=ijikespeed;
	}
}

unsigned char monsterhuntcheck(_Character *p){
	//@X^[ߊl`FbN
	//@߂l@0:ߊlȂA1:X^[ߊlA2:pbN}X^[ɂꂽ

	if(p->status==MEDAMA) return 0;
	if(p->x!=pacman.x || p->y!=pacman.y) return 0;
	if(p->status==IJIKE){
		p->status=MEDAMA;
		huntedmonster++;
		p->movecount=medamaspeed;
		score+=(1<<huntedmonster)*10;
		monsterhuntedtimer=TIMER_HUNTEDSTOP;//~
		monsterhuntedsound=5100;
		return 1;
	}
	gamestatus=2;
	return 2;
}
void huntedcheck(void){
	//@e̕ߊlAՓ˃`FbN

	unsigned char d;
	if(monsterhuntedtimer>0) return; //ڋʈȊO~
	d=GETMAP(pacman.x,pacman.y);
	if(d==MAP_COOKIE){
		//Hׂ
		SETMAP(pacman.x,pacman.y,MAP_NONE);
		score++;
		cookie--;
		cookiesoundcount=4;
	}
	else if(d==MAP_POWERCOOKIE){
		//p[Hׂ
		SETMAP(pacman.x,pacman.y,MAP_NONE);
		score+=5;
		cookie--;
		cookiesoundcount=4;
		huntedmonster=0;
		setmonsterijike(&akabei);
		setmonsterijike(&pinky);
		setmonsterijike(&aosuke);
		setmonsterijike(&guzuta);
	}
	else if(d==MAP_FRUIT){
		//t[cHׂ
		getfruit();
	}
	if(cookie==0){
		//Xe[WNA
		gamestatus=3;
		return;
	}
	if(monsterhuntcheck(&akabei)) return;
	if(monsterhuntcheck(&pinky)) return;
	if(monsterhuntcheck(&aosuke)) return;
	if(monsterhuntcheck(&guzuta)) return;
	if(upflag==0 && score>=1000){
		upflag=1;
		player++;
		displayplayers();
		over10000soundcount=63;
	}
}

// R[q[uCN1`3
void coffeebreak1(void){
	unsigned char x,animc,animv,movec;
	clearscreen();
	initcharacter(&pacman,0,29,14,DIR_LEFT,8,5,0);
	initcharacter(&akabei,OIKAKE,34,14,DIR_LEFT,7,0,0);
	startmusic(musicdata2);
	while(akabei.x<35){
		if(pacman.x<30) putpacman();
		if(akabei.x<30) putmonster(&akabei,COLOR_AKABEI);
		playmusic60thsec();
		if(pacman.x<30) printchar(pacman.x,pacman.y,0,0);
		if(akabei.x<30) printchar(akabei.x,akabei.y,0,0);
		pacman.movecount--;
		if(pacman.movecount==0){
			pacman.x--;
			pacman.movecount=8;
		}
		akabei.movecount--;
		if(akabei.movecount==0){
			akabei.x--;
			akabei.movecount=7;
		}
	}
	for(x=0;x<20;x++){
		playmusic60thsec();
	}
	x=256-6;
	animc=5;
	animv=0;
	movec=7;
	initcharacter(&akabei,IJIKE,0,14,DIR_RIGHT,8,0,10);
	while(akabei.x<35){
		if(x<30){
			printchar(x,13,COLOR_PACMAN,CODE_COFFEE1);
			printchar(x,14,COLOR_PACMAN,CODE_COFFEE1+1);
		}
		if((unsigned char)(x+1)<30){
			if(animv!=3){
				printchar(x+1,13,COLOR_PACMAN,CODE_COFFEE1+2+animv*2);
				printchar(x+1,14,COLOR_PACMAN,CODE_COFFEE1+2+animv*2+1);
			}
			else{
				printchar(x+1,13,COLOR_PACMAN,CODE_COFFEE1+4);
				printchar(x+1,14,COLOR_PACMAN,CODE_COFFEE1+5);
			}
		}
		animc--;
		if(animc==0){
			animc=5;
			animv++;
			if(animv==4) animv=0;
		}
		if(akabei.x<30) putmonster(&akabei,COLOR_AKABEI);
		playmusic60thsec();
		if(x<30){
			printchar(x,13,0,0);
			printchar(x,14,0,0);
		}
		if((unsigned char)(x+1)<30){
			printchar(x+1,13,0,0);
			printchar(x+1,14,0,0);
		}
		if(akabei.x<30) printchar(akabei.x,akabei.y,0,0);
		movec--;
		if(movec==0){
			x++;
			movec=7;
		}
		akabei.movecount--;
		if(akabei.movecount==0){
			akabei.x++;
			akabei.movecount=8;
		}
	}
	for(x=0;x<30;x++){
		playmusic60thsec();
	}
}
void coffeebreak2(void){
	unsigned char animc,animv;
	clearscreen();
	initcharacter(&pacman,0,29,14,DIR_LEFT,8,5,0);
	initcharacter(&akabei,OIKAKE,34,14,DIR_LEFT,8,0,0);
	startmusic(musicdata2+82);
	while(akabei.x>=15){
		printchar(14,14,7,CODE_COFFEE2);
		if(pacman.x<30) putpacman();
		if(akabei.x<30) putmonster(&akabei,COLOR_AKABEI);
		playmusic60thsec();
		if(pacman.x<30) printchar(pacman.x,pacman.y,0,0);
		if(akabei.x<30) printchar(akabei.x,akabei.y,0,0);
		pacman.movecount--;
		if(pacman.movecount==0){
			pacman.x--;
			pacman.movecount=8;
		}
		akabei.movecount--;
		if(akabei.movecount==0){
			akabei.x--;
			akabei.movecount=8;
		}
	}
	putmonster(&akabei,COLOR_AKABEI);
	animc=20;
	animv=0;
	while(animv<=3){
		if(pacman.x<30) putpacman();
		animc--;
		if(animc==0){
			printchar(akabei.x-1,akabei.y,COLOR_AKABEI,CODE_COFFEE2+animv*2+1);
			printchar(akabei.x  ,akabei.y,COLOR_AKABEI,CODE_COFFEE2+animv*2+2);
			animc=20;
			animv++;
		}
		playmusic60thsec();
		if(pacman.x<30) printchar(pacman.x,pacman.y,0,0);
		pacman.movecount--;
		if(pacman.movecount==0){
			pacman.x--;
			pacman.movecount=8;
		}
	}
	for(animc=0;animc<90;animc++){
		playmusic60thsec();
	}
}
void coffeebreak3(void){
	unsigned char x,movec;
	clearscreen();
	initcharacter(&pacman,0,29,14,DIR_LEFT,7,5,0);
	x=pacman.x+3;
	movec=7;
	startmusic(musicdata2);
	while(x<33){
		if(pacman.x<30) putpacman();
		if(x<30) printchar(x,14,COLOR_AKABEI,CODE_COFFEE3);
		playmusic60thsec();
		if(pacman.x<30) printchar(pacman.x,pacman.y,0,0);
		if(x<30) printchar(x,14,0,0);
		pacman.movecount--;
		if(pacman.movecount==0){
			pacman.x--;
			pacman.movecount=7;
		}
		movec--;
		if(movec==0){
			x--;
			movec=7;
		}
	}
	for(x=0;x<60;x++){
		playmusic60thsec();
	}
	x=0;
	movec=7;
	while(x<31){
		if(x<30){
			printchar(x,14,COLOR_MONSTERNUDE,CODE_COFFEE3+2);
		}
		if((unsigned char)(x-1)<30){
			printchar(x-1,14,COLOR_AKABEI,CODE_COFFEE3+1);
		}
		playmusic60thsec();
		if(x<30){
			printchar(x,14,0,0);
		}
		if((unsigned char)(x-1)<30){
			printchar(x-1,14,0,0);
		}
		movec--;
		if(movec==0){
			x++;
			movec=7;
		}
	}
	for(x=0;x<60;x++){
		playmusic60thsec();
	}
}
void gamestart(void){
	unsigned int i;
	printstr(8,15,6,"READY!");
	if(gamestatus==0){ //Q[Jn
		startmusic(musicdata1);//Q[X^[g̉yJn
		for(i=0;i<120;i++){ //܂2bԉt
			playmusic60thsec();
		}
		//LN^[\čŌ܂ŉt
		player--;
		displaychars();
		displayplayers();
		while(music.stop==0){
			playmusic60thsec();
		}
	}
	else{
		displaychars();
		displayplayers();
		wait60thsec(120); //2bEFCg
	}
	printstr(8,15,0,"      "); //READY
}
void deadanim(void){
	//pbN}ꂽƂ̃Aj[VTEh
	unsigned char i,j;
	wait60thsec(120); //2bEFCg
	erasechars();
	for(i=0;i<9;i++){
		printchar(pacman.x,pacman.y,COLOR_PACMAN,i+CODE_PACMANDEATH);
		if(i>1 && i<8){
			for(j=0;j<13;j++){
				PR3=2400+(i-2)*320+(2400+(i-2)*320)*(12-j)/12;
				wait60thsec(1); // 1/60bEFCg
	 		}
	 	}
	 	else if(i==8){
			for(j=0;j<13;j++){
				PR3=1700+1700*(12-j)/12;
	 			wait60thsec(1); // 1/60bEFCg
	 		}
	 	}
	}
	printchar(pacman.x,pacman.y,0,' ');
	for(j=0;j<13;j++){
		PR3=1700+1700*(12-j)/12;
		wait60thsec(1); // 1/60bEFCg
	}
	PR3=0;//TEh~
}
void stageclear(void){
	//ʃNAƂ̃Aj[V
	int i;
 	wait60thsec(120); //2bEFCg
	erasechars();
	printchar(pacman.x,pacman.y,COLOR_PACMAN,CODE_PACMAN);
	for(i=1;i<=6;i++){
 		wait60thsec(10); // 10/60bEFCg
		set_palette(COLOR_WALL,255,255,255); //ǂ̐F𔒂
 		wait60thsec(10); // 10/60bEFCg
		set_palette(COLOR_WALL,250,20,40); //ǂ̐F߂
	}
	switch(stage){ //R[q[uCN`FbN
		case 2:
			coffeebreak1();
			break;
		case 5:
			coffeebreak2();
			break;
		case 9:
		case 13:
		case 17:
			coffeebreak3();
	}
}
void gameover(){
	//Q[I[o[
	printstr(6,10,2,"GAME OVER");
	wait60thsec(180); // 3bEFCg
	if(highscore>*(unsigned int *)FLASHPAGE) writehighscore();
}

void scroll(){
	//1sXN[
	unsigned char *p;
	for(p=TVRAM;p<TVRAM+WIDTH_X*(WIDTH_Y-1);p++) *p=*(p+WIDTH_X);
	for(;p<TVRAM+WIDTH_X*WIDTH_Y;p++) *p=0;
	for(p=TVRAM+ATTROFFSET;p<TVRAM+WIDTH_X*(WIDTH_Y-1)+ATTROFFSET;p++) *p=*(p+WIDTH_X);
	for(;p<TVRAM+WIDTH_X*WIDTH_Y+ATTROFFSET;p++) *p=0;
}
void title(void){
	//^Cgʕ\
	int i;
	clearscreen();
	while(1){
		for(i=1;i<=3;i++){
			if(startkeycheck(5)) return;// 605bEFCgȂX^[g{^`FbN
			scroll(); //1sXN[
		}
		printstr(5,26,2,"1UP");
		printstr(18,26,2,"HI-SCORE");
		if(startkeycheck(5)) return;
		scroll();
		printscore(4,26,7,score);
		printchar(10,26,7,'0');
		printscore(19,26,7,highscore);
		printchar(25,26,7,'0');

		for(i=1;i<=5;i++){
			if(startkeycheck(5)) return;
			scroll();
		}
		//S\
		printstr(8,26,2,"\xf4\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf5\xf6");
		if(startkeycheck(5)) return;
		scroll();
		printchar(8,26,2,0xf7);
		printstr(9,26,6,"\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb");
		printchar(21,26,2,0xf8);
		if(startkeycheck(5)) return;
		scroll();
		printchar(8,26,2,0xf7);
		printstr(9,26,6,"\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7");
		printchar(21,26,2,0xf8);
		if(startkeycheck(5)) return;
		scroll();
		printchar(8,26,2,0xf7);
		printstr(9,26,6,"\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3");
		printchar(21,26,2,0xf8);
		if(startkeycheck(5)) return;
		scroll();
		printstr(8,26,2,"\xf9\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfb");
		//S\܂

		for(i=1;i<=6;i++){
			if(startkeycheck(5)) return;
			scroll();
		}
		printstr(11,26,7,"BY KENKEN");
		if(startkeycheck(5)) return;
		scroll();
		printstr(13,26,7,"WITH");
		if(startkeycheck(5)) return;
		scroll();
		printstr(1,26,7,"COLOR-TEXT VIDEO OUT SYSTEM");
		if(startkeycheck(5)) return;
		scroll();
		printstr(10,26,7,"FOR PIC32MX");
		for(i=1;i<=4;i++){
			if(startkeycheck(5)) return;
			scroll();
		}
		printstr(6,26,4,"PUSH START BUTTON");
		if(startkeycheck(5)) return;
		scroll();
		if(startkeycheck(600)) return;//10bEFCg

		clearscreen();
		printstr(5,2,2,"1UP");
		printstr(18,2,2,"HI-SCORE");
		printscore(4,3,7,score);
		printchar(10,3,7,'0');
		printscore(19,3,7,highscore);
		printchar(25,3,7,'0');
		printstr(4,6,7,"CHARACTER  /  NICKNAME");
		if(startkeycheck(50)) return;
		printstr(3,9,COLOR_AKABEI,"\xb1 OIKAKE\x90\x90\x90\x90\x90\x90\x90");
		if(startkeycheck(50)) return;
		printstr(18,9,COLOR_AKABEI,"\"AKABEI\"");
		if(startkeycheck(50)) return;
		printstr(3,12,COLOR_PINKY,"\xb1 MACHIBUSE\x90\x90\x90\x90");
		if(startkeycheck(50)) return;
		printstr(18,12,COLOR_PINKY,"\"PINKY\"");
		if(startkeycheck(50)) return;
		printstr(3,15,COLOR_AOSUKE,"\xb1 KIMAGURE\x90\x90\x90\x90\x90");
		if(startkeycheck(50)) return;
		printstr(18,15,COLOR_AOSUKE,"\"AOSUKE\"");
		if(startkeycheck(50)) return;
		printstr(3,18,COLOR_GUZUTA,"\xb1 OTOBOKE\x90\x90\x90\x90\x90\x90");
		if(startkeycheck(50)) return;
		printstr(18,18,COLOR_GUZUTA,"\"GUZUTA\"");
		if(startkeycheck(50)) return;
		printchar(11,21,COLOR_COOKIE,CODE_COOKIE);
		printstr(13,21,7,"10 PTS");
		printchar(11,22,COLOR_POWERCOOKIE,CODE_POWERCOOKIE);
		printstr(13,22,7,"50 PTS");
		printstr(6,25,4,"PUSH START BUTTON");
		if(startkeycheck(600)) return;
	}
}
void game(void){
	gameinit2();//XRAȂǏ
	gamestatus=0;//0:Q[X^[gA1:Q[A2:vC[1A3:Xe[WNAA4:Q[I[o[
	while(gamestatus<4){
		gameinit3();//V[NAAʘH\
		if(gamestatus==3) gamestatus=1;
		while(gamestatus<3){
			gamecount=0;//S̃JE^[
			gameinit4();//pbN}AX^[ʒuȂ
			gamestart();//Ready!\
			gamestatus=1;
			drawcount=0;
			while(gamestatus==1){
				while(drawcount==0) asm("wait");//AChɂĊ荞ݑ҂
				drawcount=0;
				gamecount++;
				sound();		//ʉo
				erasechars();	//LN^[\
				keycheck();		//{^`FbN
				movechars();	//LN^[ړ
				displaychars();	//LN^[\
				fruitcheck();	//t[c֌W`FbN
				huntedcheck();	//HAHꂽ`FbN
				displayscore();	//XRA\
			}
			PR3=0;//TEh~
			set_palette(COLOR_POWERCOOKIE,0,255,255);//p[̐FWɖ߂
			if(gamestatus==2){
				deadanim(); //pbN}ꂽ̃Aj[V
				if(player==0) gamestatus=4;//Q[I[o[
				else player--;
			}
			else if(gamestatus==3){
				//Xe[WNA
				stageclear(); //Xe[WNAAj[VAR[q[uCN
			}
		}
	}
	gameover(); //Q[I
}
			
int main(void){

	//|[g̏ݒ
	TRISA = 0x0010; // RA4͓
	CNPUA = 0x0010; // RA4vAbv
	ANSELA = 0x0000; // SăfW^
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ANSELB = 0x0000; // SăfW^
	LATACLR=2;// RA1=0i{^[hj

	RPB13R=5;//RPB13sOC4蓖
	OC4R=0;
	OC4CON=0x000b;// Tiemr3x[XAToggle[h
	OC4CONSET=0x8000;//OC4X^[g
	T3CON=0x0030;// vXP[1:8
	PR3=0;
	T3CONSET=0x8000;// ^C}3X^[g

	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn

	gameinit(); //Q[S̏
	while(1){
		title();//^CgʁAX^[g{^Ŗ߂
		game();//Q[C[v
	}
}
